/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.javassist;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import cn.featherfly.common.lang.matcher.MethodNameRegexMatcher;
import cn.featherfly.rc.ConfigurationValuePersistence;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class DynamicConfigurationFacotry {
    private Set<Class<?>> types = new HashSet();
    private static final DynamicConfigurationFacotry INSTANCE = new DynamicConfigurationFacotry();

    public static DynamicConfigurationFacotry getInstance() {
        return INSTANCE;
    }

    public String create(Class<?> type) throws NotFoundException, CannotCompileException {
        String dynamicClassName = type.getPackage().getName() + "._" + type.getSimpleName() + "DynamicImpl";
        if (!this.types.contains(type)) {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
            CtClass dynamicImplClass = pool.makeClass(dynamicClassName);
            dynamicImplClass.setInterfaces(new CtClass[]{pool.getCtClass(type.getName())});
            CtField nameField = new CtField(pool.getCtClass(String.class.getName()), "name", dynamicImplClass);
            nameField.setModifiers(2);
            dynamicImplClass.addField(nameField);
            CtField configurationValuePersistenceField = new CtField(pool.getCtClass(ConfigurationValuePersistence.class.getName()), "configurationValuePersistence", dynamicImplClass);
            configurationValuePersistenceField.setModifiers(2);
            dynamicImplClass.addField(configurationValuePersistenceField);
            CtConstructor constraConstructor = new CtConstructor(new CtClass[]{pool.getCtClass(String.class.getName()), pool.getCtClass(ConfigurationValuePersistence.class.getName())}, dynamicImplClass);
            constraConstructor.setModifiers(1);
            constraConstructor.setBody("{this.name=$1;this.configurationValuePersistence=$2;}");
            dynamicImplClass.addConstructor(constraConstructor);
            Collection getMethods = ClassUtils.findMethods(type, (MethodMatcher)new MethodNameRegexMatcher("get.+"));
            Collection setMethods = ClassUtils.findMethods(type, (MethodMatcher)new MethodNameRegexMatcher("set.+"));
            for (Method getMethod : getMethods) {
                CtMethod ctMethod = new CtMethod(pool.getCtClass(getMethod.getReturnType().getTypeName()), getMethod.getName(), new CtClass[0], dynamicImplClass);
                ctMethod.setBody(String.format("{return (%2$s) configurationValuePersistence.get(name, \"%s\", %2$s.class);}", ClassUtils.getPropertyName((Method)getMethod), getMethod.getReturnType().getTypeName()));
                ctMethod.setModifiers(1);
                dynamicImplClass.addMethod(ctMethod);
            }
            for (Method setMethod : setMethods) {
                ArrayList<CtClass> params = new ArrayList<CtClass>();
                for (Class<?> paramType : setMethod.getParameterTypes()) {
                    params.add(pool.getCtClass(paramType.getName()));
                }
                CtMethod ctMethod = new CtMethod(pool.getCtClass(setMethod.getReturnType().getTypeName()), setMethod.getName(), (CtClass[])CollectionUtils.toArray(params, CtClass.class), dynamicImplClass);
                ctMethod.setBody(String.format("{configurationValuePersistence.set(name, \"%s\", $1);return this;}", ClassUtils.getPropertyName((Method)setMethod)));
                ctMethod.setModifiers(1);
                dynamicImplClass.addMethod(ctMethod);
            }
            dynamicImplClass.toClass();
            dynamicImplClass.detach();
            this.types.add(type);
        }
        return dynamicClassName;
    }
}

