/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.repository;

import cn.featherfly.common.io.Properties;
import cn.featherfly.common.io.PropertiesImpl;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import cn.featherfly.common.lang.matcher.MethodNameRegexMatcher;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.annotation.Configuration;
import cn.featherfly.rc.annotation.Configurations;
import cn.featherfly.rc.repository.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class PropertiesFileConfigurator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, File> configFileMap = new HashMap<String, File>();
    private Map<String, Properties> propertiesMap = new HashMap<String, Properties>();
    private static final String DIR_NAME = ".featherfly_configuration";
    private FilePolicy filePolicy = FilePolicy.EACH_FILE_FOR_DEFINE;
    private DirPolicy dirPolicy = DirPolicy.USER_DIR;
    private Set<MetadataReader> metadataReaders = new HashSet<MetadataReader>();
    private File storeDir;
    private String projectName;

    public PropertiesFileConfigurator(String projectName, Set<MetadataReader> metadataReaders) {
        this(projectName, FilePolicy.EACH_FILE_FOR_DEFINE, DirPolicy.USER_DIR, metadataReaders);
    }

    public PropertiesFileConfigurator(String projectName, FilePolicy filePolicy, DirPolicy dirPolicy, Set<MetadataReader> metadataReaders) {
        AssertIllegalArgument.isNotNull((Object)projectName, (String)"projectName");
        this.projectName = projectName;
        this.filePolicy = filePolicy;
        this.dirPolicy = dirPolicy;
        this.metadataReaders = metadataReaders;
        this.init();
    }

    private void init() {
        if (this.dirPolicy == DirPolicy.USER_DIR) {
            this.storeDir = new File(FileUtils.getUserDirectoryPath() + "/" + DIR_NAME + "/" + this.projectName);
        }
        if (this.filePolicy == FilePolicy.EACH_FILE_FOR_DEFINE || this.filePolicy == FilePolicy.EACH_FILE_FOR_DEFINE_IN_PACKAGE) {
            for (MetadataReader metadataReader : this.metadataReaders) {
                PropertiesImpl properties;
                if (!metadataReader.getAnnotationMetadata().hasAnnotation(Configurations.class.getName())) continue;
                Class type = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName());
                String configName = type.getAnnotation(Configurations.class).name();
                String descp = type.getAnnotation(Configurations.class).descp();
                File file = this.filePolicy == FilePolicy.EACH_FILE_FOR_DEFINE_IN_PACKAGE ? new File(this.storeDir.getAbsoluteFile() + "/" + ClassUtils.packageToDir((Class)type) + "/" + type.getSimpleName() + ".properties") : new File(this.storeDir.getAbsoluteFile() + "/" + configName + ".properties");
                if (!file.exists()) {
                    properties = new PropertiesImpl();
                    this.createFile(file, configName);
                    this.configFileMap.put(configName, file);
                    try {
                        properties.setProperty(type.getName(), configName, descp);
                        Collection getMethods = ClassUtils.findMethods((Class)type, (MethodMatcher)new MethodNameRegexMatcher("get.+"));
                        Collection setMethods = ClassUtils.findMethods((Class)type, (MethodMatcher)new MethodNameRegexMatcher("set.+"));
                        HashMap map = new HashMap();
                        for (Method setMethod : setMethods) {
                            Lang.ifNotEmpty((Object)setMethod.getAnnotation(Configuration.class), a -> map.put(ClassUtils.getPropertyName((Method)setMethod), a));
                        }
                        for (Method getMethod : getMethods) {
                            Lang.ifNotEmpty((Object)getMethod.getAnnotation(Configuration.class), a -> map.put(ClassUtils.getPropertyName((Method)getMethod), a));
                        }
                        map.entrySet().forEach(arg_0 -> PropertiesFileConfigurator.lambda$init$4((Properties)properties, arg_0));
                        properties.store((OutputStream)new FileOutputStream(file));
                        this.logger.debug("create file {} for {}", (Object)file.getAbsolutePath(), (Object)type.getName());
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage());
                        ConfigurationException.throwConfigNotInit((String)configName, (String)"*");
                    }
                } else {
                    this.configFileMap.put(configName, file);
                    properties = this.loadConfig(configName);
                }
                this.propertiesMap.put(configName, (Properties)properties);
            }
        }
    }

    public File getConfigFile(String config) {
        return this.configFileMap.get(config);
    }

    private void createFile(File file, String configName) {
        try {
            FileUtils.write((File)file, (CharSequence)"", (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            ConfigurationException.throwConfigNotInit((String)configName, (String)"*");
        }
    }

    public Set<MetadataReader> getMetadataReaders() {
        return this.metadataReaders;
    }

    public FilePolicy getFilePolicy() {
        return this.filePolicy;
    }

    public void setFilePolicy(FilePolicy filePolicy) {
        this.filePolicy = filePolicy;
    }

    public DirPolicy getDirPolicy() {
        return this.dirPolicy;
    }

    public void setDirPolicy(DirPolicy dirPolicy) {
        this.dirPolicy = dirPolicy;
    }

    public PropertiesFileConfigurator setConfig(String configName, Config ... configs) {
        Properties properties = this.loadConfig(configName);
        for (Config config : configs) {
            properties.setProperty(config.getName(), config.getValue(), config.getDescp());
            try {
                properties.store((OutputStream)new FileOutputStream(this.configFileMap.get(configName)));
                this.propertiesMap.put(configName, properties);
            }
            catch (IOException e) {
                throw new ConfigurationException(String.format("\u4e3a%s\u7684%s\u8bbe\u7f6e\u503c%s\u65f6\u53d1\u751f\u9519\u8bef%s", configName, config.getName(), config.getValue(), e.getMessage()));
            }
        }
        return this;
    }

    public Config getConfig(String configName, String name) {
        Properties properties = this.propertiesMap.get(configName);
        Properties.Property p = properties.getPropertyPart(name);
        Config config = new Config();
        config.setName(name);
        if (p != null) {
            config.setValue(p.getValue());
            config.setDescp(p.getComment());
        }
        return config;
    }

    public Config getConfigDifinition(String configName) {
        Config config = new Config();
        Properties properties = this.propertiesMap.get(configName);
        config.setConfigName(configName);
        for (Properties.Property p : properties.getPropertyParts()) {
            if (!p.getKey().contains(".")) continue;
            config.setConfigDescp(p.getComment());
            break;
        }
        return config;
    }

    private Properties loadConfig(String configName) {
        File file = this.configFileMap.get(configName);
        if (file == null) {
            throw new ConfigurationException(String.format("%s\u7684\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230", configName));
        }
        try {
            PropertiesImpl properties = new PropertiesImpl();
            properties.load((InputStream)new FileInputStream(file));
            return properties;
        }
        catch (IOException e) {
            throw new ConfigurationException(String.format("\u52a0\u8f7d%s\u7684\u914d\u7f6e\u6587\u4ef6%s\u62a5\u9519", configName, file.getPath()));
        }
    }

    public Set<String> getConfigNames() {
        return this.configFileMap.keySet();
    }

    public List<Config> getConfigs(String config) {
        ArrayList<Config> configs = new ArrayList<Config>();
        Properties properties = this.propertiesMap.get(config);
        String descp = null;
        for (Properties.Property p : properties.getPropertyParts()) {
            if (p.getKey().contains(".")) {
                descp = p.getComment();
                continue;
            }
            Config c = new Config();
            c.setConfigName(config);
            c.setConfigDescp(descp);
            c.setName(p.getKey());
            c.setValue(p.getValue());
            c.setDescp(p.getComment());
            configs.add(c);
        }
        return configs;
    }

    private static /* synthetic */ void lambda$init$4(Properties properties, Map.Entry e) {
        properties.setProperty((String)Lang.ifEmpty((Object)((Configuration)e.getValue()).name(), () -> (String)e.getKey(), n -> n), ((Configuration)e.getValue()).value(), ((Configuration)e.getValue()).descp());
    }

    public static enum DirPolicy {
        USER_DIR;

    }

    public static enum FilePolicy {
        EACH_FILE_FOR_DEFINE,
        EACH_FILE_FOR_DEFINE_IN_PACKAGE;

    }
}

