/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.repository;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.reflect.GenericClass;
import cn.featherfly.conversion.string.ToStringConversionPolicys;
import cn.featherfly.conversion.string.ToStringTypeConversion;
import cn.featherfly.rc.Configuration;
import cn.featherfly.rc.ConfigurationRepository;
import cn.featherfly.rc.ConfigurationValue;
import cn.featherfly.rc.SimpleConfiguration;
import cn.featherfly.rc.SimpleConfigurationValue;
import cn.featherfly.rc.repository.Config;
import cn.featherfly.rc.repository.PropertiesFileConfigurator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFileRepository
implements ConfigurationRepository {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PropertiesFileConfigurator configurator;
    private ToStringTypeConversion conversion;

    public ConfigurationFileRepository(PropertiesFileConfigurator configurator) {
        this(configurator, new ToStringTypeConversion(ToStringConversionPolicys.getBasicConversionPolicy()));
    }

    public ConfigurationFileRepository(PropertiesFileConfigurator configurator, ToStringTypeConversion conversion) {
        this.configurator = configurator;
        this.conversion = conversion;
    }

    public <V> ConfigurationRepository set(String configName, String name, V value) {
        Config config = new Config();
        config.setName(name);
        config.setValue(this.conversion.sourceToTarget(value, value.getClass()));
        this.configurator.setConfig(configName, config);
        return this;
    }

    public ConfigurationRepository set(String configName, Map<String, Object> configNameValueMap) {
        this.configurator.setConfig(configName, (Config[])configNameValueMap.entrySet().stream().map(e -> new Config((String)e.getKey(), this.conversion.sourceToTarget(e.getValue(), e.getValue().getClass()))).toArray(value -> new Config[configNameValueMap.size()]));
        return this;
    }

    public <V> V get(String configName, String name, Class<V> type) {
        String valueStr = (String)Lang.ifNotEmpty((Object)this.configurator.getConfig(configName, name), c -> c.getValue(), () -> null);
        return (V)this.conversion.targetToSource(valueStr, (GenericType)new GenericClass(type));
    }

    public Collection<Configuration> getConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        for (String name : this.configurator.getConfigNames()) {
            configurations.add(this.getConfiguration(name));
        }
        return configurations;
    }

    public Configuration getConfiguration(String name) {
        Config config = this.configurator.getConfigDifinition(name);
        SimpleConfiguration simpleConfiguration = new SimpleConfiguration(name, config.getDescp(), (ConfigurationRepository)this);
        return simpleConfiguration;
    }

    public <C extends Configuration> C getConfiguration(String name, Class<C> type) {
        Configuration configuration = (Configuration)ClassUtils.newInstance(type, (Object[])new Object[]{name, this});
        return (C)configuration;
    }

    public List<ConfigurationValue<?>> getConfigurations(String name) {
        return this.configurator.getConfigs(name).stream().map(c -> {
            SimpleConfigurationValue value = new SimpleConfigurationValue();
            value.setName(c.getName());
            value.setValue((Object)c.getValue());
            value.setDescp(c.getDescp());
            return value;
        }).collect(Collectors.toList());
    }
}

