/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc.javassist;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import cn.featherfly.common.lang.matcher.MethodNameRegexMatcher;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.ConfigurationRepository;
import cn.featherfly.rc.annotation.Configurations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

public class DynamicConfigurationFacotry {
    private ClassLoader classLoader;
    private Set<Class<?>> types = new HashSet();
    private static final DynamicConfigurationFacotry INSTANCE = new DynamicConfigurationFacotry();
    private Map<Class<?>, Object> typeInstances = new HashMap();

    public static DynamicConfigurationFacotry getInstance() {
        return INSTANCE;
    }

    public <E> E newInstance(Class<E> type, ConfigurationRepository repository) {
        try {
            AssertIllegalArgument.isNotNull(type, (String)"type");
            AssertIllegalArgument.isNotNull((Object)repository, (String)"repository");
            Configurations cd = type.getAnnotation(Configurations.class);
            if (cd == null) {
                throw new ConfigurationException(String.format("there is no annotation[%s] in type[%s]", Configurations.class.getName(), type.getName()));
            }
            String configName = cd.name();
            return (E)ClassUtils.forName((String)this.create(type)).getConstructor(String.class, ConfigurationRepository.class).newInstance(configName, repository);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public <E> E instance(Class<E> type, ConfigurationRepository repository) {
        Object e = null;
        e = this.typeInstances.get(type);
        if (e == null) {
            e = this.newInstance(type, repository);
            this.typeInstances.put(type, e);
        }
        return (E)e;
    }

    public String create(Class<?> type) throws NotFoundException, CannotCompileException {
        return this.create(type, this.getClass().getClassLoader());
    }

    public String create(Class<?> type, ClassLoader classLoader) throws NotFoundException, CannotCompileException {
        String dynamicClassName = type.getPackage().getName() + "._" + type.getSimpleName() + "DynamicImpl";
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (this.classLoader == null) {
            this.classLoader = classLoader;
        }
        if (this.classLoader != classLoader) {
            this.clear();
            this.classLoader = classLoader;
        }
        if (!this.types.contains(type)) {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new ClassClassPath(this.getClass()));
            CtClass dynamicImplClass = pool.makeClass(dynamicClassName);
            dynamicImplClass.setInterfaces(new CtClass[]{pool.getCtClass(type.getName())});
            CtField nameField = new CtField(pool.getCtClass(String.class.getName()), "name", dynamicImplClass);
            nameField.setModifiers(2);
            dynamicImplClass.addField(nameField);
            CtField configurationRepositoryField = new CtField(pool.getCtClass(ConfigurationRepository.class.getName()), "configurationRepository", dynamicImplClass);
            configurationRepositoryField.setModifiers(2);
            dynamicImplClass.addField(configurationRepositoryField);
            CtConstructor constraConstructor = new CtConstructor(new CtClass[]{pool.getCtClass(String.class.getName()), pool.getCtClass(ConfigurationRepository.class.getName())}, dynamicImplClass);
            constraConstructor.setModifiers(1);
            constraConstructor.setBody("{this.name=$1;this.configurationRepository=$2;}");
            dynamicImplClass.addConstructor(constraConstructor);
            Collection getMethods = ClassUtils.findMethods(type, (MethodMatcher)new MethodNameRegexMatcher("get.+"));
            Collection setMethods = ClassUtils.findMethods(type, (MethodMatcher)new MethodNameRegexMatcher("set.+"));
            for (Method getMethod : getMethods) {
                CtMethod ctMethod = new CtMethod(pool.getCtClass(getMethod.getReturnType().getTypeName()), getMethod.getName(), new CtClass[0], dynamicImplClass);
                ctMethod.setBody(String.format("{return (%2$s) configurationRepository.get(name, \"%s\", %2$s.class);}", ClassUtils.getPropertyName((Method)getMethod), getMethod.getReturnType().getTypeName()));
                ctMethod.setModifiers(1);
                dynamicImplClass.addMethod(ctMethod);
            }
            for (Method setMethod : setMethods) {
                ArrayList<CtClass> params = new ArrayList<CtClass>();
                for (Class<?> paramType : setMethod.getParameterTypes()) {
                    params.add(pool.getCtClass(paramType.getName()));
                }
                CtMethod ctMethod = new CtMethod(pool.getCtClass(setMethod.getReturnType().getTypeName()), setMethod.getName(), (CtClass[])CollectionUtils.toArray(params, CtClass.class), dynamicImplClass);
                ctMethod.setBody(String.format("{configurationRepository.set(name, \"%s\", $1);return this;}", ClassUtils.getPropertyName((Method)setMethod)));
                ctMethod.setModifiers(1);
                dynamicImplClass.addMethod(ctMethod);
            }
            dynamicImplClass.toClass(classLoader, dynamicImplClass.getClass().getProtectionDomain());
            dynamicImplClass.detach();
            this.types.add(type);
        }
        return dynamicClassName;
    }

    private void clear() {
        this.types.clear();
        this.typeInstances.clear();
    }
}

