/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc;

import cn.featherfly.common.io.ClassPathScanningProvider;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.rc.ConfigurationException;
import cn.featherfly.rc.annotation.Configurations;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.type.classreading.MetadataReader;

public class ConfigurationManager {
    private static final ConfigurationManager DEFAULT = new ConfigurationManager();
    private Map<String, String> configNameTypeMap = new HashMap<String, String>();

    public static ConfigurationManager getInstance() {
        return DEFAULT;
    }

    public Set<MetadataReader> getConfigurations(Set<MetadataReader> metadataReaders) {
        HashSet<MetadataReader> configurations = new HashSet<MetadataReader>();
        for (MetadataReader metadataReader : metadataReaders) {
            if (!metadataReader.getAnnotationMetadata().hasAnnotation(Configurations.class.getName())) continue;
            this.check(metadataReader);
            configurations.add(metadataReader);
        }
        return configurations;
    }

    public Set<MetadataReader> scanConfigurations(String ... basePackages) {
        return this.getConfigurations(new ClassPathScanningProvider().findMetadata(basePackages));
    }

    private void check(MetadataReader metadataReader) {
        Class type = ClassUtils.forName((String)metadataReader.getClassMetadata().getClassName());
        String configName = type.getAnnotation(Configurations.class).name();
        String t = this.configNameTypeMap.get(configName);
        if (t != null && !t.equals(type.getName())) {
            ConfigurationException.throwConfigDuplicateKey((String)configName, (String)this.configNameTypeMap.get(configName), (String)type.getName());
        }
        this.configNameTypeMap.put(configName, type.getName());
    }
}

