/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.rc;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.rc.Configuration;
import cn.featherfly.rc.ConfigurationRepository;
import java.io.Serializable;

public class SimpleConfiguration
implements Configuration {
    private String name;
    private String descp;
    private ConfigurationRepository configurationRepository;

    public SimpleConfiguration(String name, String descp, ConfigurationRepository configurationRepository) {
        AssertIllegalArgument.isNotNull((Object)name, (String)"name");
        AssertIllegalArgument.isNotNull((Object)configurationRepository, (String)"configurationRepository");
        this.name = name;
        this.descp = descp;
        this.configurationRepository = configurationRepository;
    }

    @Override
    public <V extends Serializable> V get(String key, Class<V> type) {
        return (V)((Serializable)this.configurationRepository.get(this.name, key, type));
    }

    @Override
    public <V extends Serializable> Configuration set(String key, V value) {
        this.configurationRepository.set(this.name, key, value);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescp() {
        return this.descp;
    }

    public String toString() {
        return "SimpleConfiguration [name=" + this.name + ", descp=" + this.descp + "]";
    }
}

