/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.validation.apt;

import cn.featherfly.common.ast.JavacProcessor;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"javax.annotation.Nonnull"})
@SupportedOptions(value={"debug"})
public class Jsr305Processor
extends JavacProcessor {
    @Override
    public void doInit(@Nonnull ProcessingEnvironment processingEnv) {
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        JavacElements elementUtils = (JavacElements)this.processingEnv.getElementUtils();
        this.messager.printMessage(Diagnostic.Kind.NOTE, "start generate check for javax.annotation.Nonnull");
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(Nonnull.class);
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Nonnull annotated element size = " + elements.size());
        for (Element element : elements) {
            if (element.getKind() != ElementKind.PARAMETER) continue;
            JCTree.JCMethodDecl jcMethodDecl = (JCTree.JCMethodDecl)elementUtils.getTree(element.getEnclosingElement());
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)elementUtils.getTree(element);
            this.addAssertToBody(jcMethodDecl, jcVariableDecl);
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Nonnull -> " + (Object)((Object)element.getEnclosingElement().getKind()) + " " + element.getEnclosingElement().getSimpleName() + " " + (Object)((Object)element.getKind()) + " " + element.getSimpleName());
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, "end generate check for javax.annotation.Nonnull");
        return true;
    }

    private void addAssertToBody(JCTree.JCMethodDecl jcMethodDecl, JCTree.JCVariableDecl jcVariableDecl) {
        String message = String.format("method %s args[%s] can not be null", jcMethodDecl.name.toString(), jcVariableDecl.name.toString());
        JCTree.JCBinary isEq = this.javac.eqNull(jcVariableDecl);
        JCTree.JCThrow throwException = this.javac.throwException(IllegalArgumentException.class, message);
        JCTree.JCIf jcIf = this.treeMaker.If(isEq, this.treeMaker.Block(0L, List.of(throwException)), null);
        List<JCTree.JCIf> stats = List.of(jcIf);
        stats = stats.appendList((List<JCTree.JCIf>)jcMethodDecl.body.getStatements());
        jcMethodDecl.body.stats = List.from(stats);
    }
}

