/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.ast;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public class Javac {
    private TreeMaker maker;
    private JavacTrees trees;
    private Names names;
    private Messager messager;
    private ProcessingEnvironment processingEnv;

    public Javac(TreeMaker maker, JavacTrees trees, Names names, Messager messager, ProcessingEnvironment processingEnv) {
        this.maker = maker;
        this.trees = trees;
        this.names = names;
        this.messager = messager;
        this.processingEnv = processingEnv;
    }

    public <E extends RuntimeException> JCTree.JCThrow throwException(Class<E> exceptionType, String exceptionMessage) {
        return this.maker.Throw(this.maker.NewClass(null, List.nil(), this.maker.Ident(this.names.fromString(exceptionType.getSimpleName())), List.of(this.maker.Literal(exceptionMessage)), null));
    }

    public <E extends RuntimeException> JCTree.JCBinary eqNull(JCTree.JCVariableDecl jcVariableDecl) {
        return this.maker.Binary(JCTree.Tag.EQ, this.maker.Ident(jcVariableDecl), this.maker.Literal(TypeTag.BOT, null));
    }

    public void addImportInfo(Element element, Class<?> importType) {
        this.log("addImportInfo for type " + importType.toString());
        TreePath treePath = this.trees.getPath(element);
        Tree leaf = treePath.getLeaf();
        if (treePath.getCompilationUnit() instanceof JCTree.JCCompilationUnit && leaf instanceof JCTree) {
            JCTree.JCImport jcImport;
            JCTree.JCCompilationUnit jccu = (JCTree.JCCompilationUnit)treePath.getCompilationUnit();
            for (JCTree jcTree : jccu.getImports()) {
                if (jcTree == null || !(jcTree instanceof JCTree.JCImport)) continue;
                jcImport = (JCTree.JCImport)jcTree;
                if (jcImport.qualid == null || !(jcImport.qualid instanceof JCTree.JCFieldAccess)) continue;
                JCTree.JCFieldAccess jcFieldAccess = jcImport.qualid;
                try {
                    if (!importType.getPackage().getName().equals(jcFieldAccess.selected.toString()) || !importType.getSimpleName().equals(jcFieldAccess.name.toString())) continue;
                    return;
                }
                catch (NullPointerException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
            ArrayList<JCTree> trees = new ArrayList<JCTree>();
            trees.addAll(jccu.defs);
            this.messager.printMessage(Diagnostic.Kind.NOTE, "jccu.defs");
            this.messager.printMessage(Diagnostic.Kind.NOTE, jccu.defs.toString());
            JCTree.JCIdent ident = this.maker.Ident(this.names.fromString(importType.getPackage().getName()));
            jcImport = this.maker.Import(this.maker.Select((JCTree.JCExpression)ident, this.names.fromString(importType.getSimpleName())), false);
            if (!trees.contains(jcImport)) {
                this.log("add import " + jcImport.toString());
                trees.add(0, jcImport);
            }
            jccu.defs = List.from(trees);
        }
    }

    public JCTree.JCMethodDecl getterMethod(JCTree.JCVariableDecl jcVariableDecl) {
        JCTree.JCModifiers jcModifiers = this.maker.Modifiers(1L);
        JCTree.JCExpression retrunType = jcVariableDecl.vartype;
        Name name = this.getGetterName(jcVariableDecl.name);
        JCTree.JCReturn jcStatement = this.maker.Return(this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("this")), jcVariableDecl.name));
        JCTree.JCBlock jcBlock = this.maker.Block(0L, List.of(jcStatement));
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression defaultValue = null;
        JCTree.JCMethodDecl jcMethodDecl = this.maker.MethodDef(jcModifiers, name, retrunType, methodGenericParams, parameters, throwsClauses, jcBlock, defaultValue);
        return jcMethodDecl;
    }

    public JCTree.JCMethodDecl setterMethod(JCTree.JCVariableDecl jcVariableDecl) {
        JCTree.JCModifiers jcModifiers = this.maker.Modifiers(1L);
        JCTree.JCPrimitiveTypeTree retrunType = this.maker.TypeIdent(TypeTag.VOID);
        Name name = this.getSetterName(jcVariableDecl.name);
        List<JCTree.JCVariableDecl> parameters = List.nil();
        JCTree.JCVariableDecl param = this.maker.VarDef(this.maker.Modifiers(0x200000000L), jcVariableDecl.name, jcVariableDecl.vartype, null);
        param.pos = jcVariableDecl.pos;
        parameters = parameters.append(param);
        JCTree.JCExpressionStatement jcStatement = this.maker.Exec(this.maker.Assign(this.maker.Select((JCTree.JCExpression)this.maker.Ident(this.names.fromString("this")), jcVariableDecl.name), this.maker.Ident(jcVariableDecl.name)));
        JCTree.JCBlock jcBlock = this.maker.Block(0L, List.of(jcStatement));
        List<JCTree.JCTypeParameter> methodGenericParams = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        JCTree.JCExpression defaultValue = null;
        JCTree.JCMethodDecl jcMethodDecl = this.maker.MethodDef(jcModifiers, name, retrunType, methodGenericParams, parameters, throwsClauses, jcBlock, defaultValue);
        return jcMethodDecl;
    }

    public Javac log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
        return this;
    }

    private Name getGetterName(Name name) {
        String s = name.toString();
        return this.names.fromString("get" + s.substring(0, 1).toUpperCase() + s.substring(1, name.length()));
    }

    private Name getSetterName(Name name) {
        String s = name.toString();
        return this.names.fromString("set" + s.substring(0, 1).toUpperCase() + s.substring(1, name.length()));
    }
}

