/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.jdbc.datasouce;

import cn.featherfly.common.spring.jdbc.datasouce.ReadWriteDataSourceDecision;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.util.CollectionUtils;

public class ReadWriteDataSource
extends AbstractDataSource
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ReadWriteDataSource.class);
    private DataSource writeDataSource;
    private Map<String, DataSource> readDataSourceMap;
    private String[] readDataSourceNames;
    private DataSource[] readDataSources;
    private int readDataSourceCount;
    private AtomicInteger counter = new AtomicInteger(1);

    public void setReadDataSourceMap(Map<String, DataSource> readDataSourceMap) {
        this.readDataSourceMap = readDataSourceMap;
    }

    public void setWriteDataSource(DataSource writeDataSource) {
        this.writeDataSource = writeDataSource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.writeDataSource == null) {
            throw new IllegalArgumentException("property 'writeDataSource' is required");
        }
        if (CollectionUtils.isEmpty(this.readDataSourceMap)) {
            throw new IllegalArgumentException("property 'readDataSourceMap' is required");
        }
        this.readDataSourceCount = this.readDataSourceMap.size();
        this.readDataSources = new DataSource[this.readDataSourceCount];
        this.readDataSourceNames = new String[this.readDataSourceCount];
        int i = 0;
        for (Map.Entry<String, DataSource> e : this.readDataSourceMap.entrySet()) {
            this.readDataSources[i] = e.getValue();
            this.readDataSourceNames[i] = e.getKey();
            ++i;
        }
    }

    private DataSource determineDataSource() {
        if (ReadWriteDataSourceDecision.isChoiceWrite()) {
            LOG.trace("current determine write datasource");
            return this.writeDataSource;
        }
        if (ReadWriteDataSourceDecision.isChoiceNone()) {
            LOG.trace("no choice read/write, default determine write datasource");
            return this.writeDataSource;
        }
        return this.determineReadDataSource();
    }

    private DataSource determineReadDataSource() {
        int index = this.counter.incrementAndGet() % this.readDataSourceCount;
        if (index < 0) {
            index = -index;
        }
        String dataSourceName = this.readDataSourceNames[index];
        LOG.trace("current determine read datasource : {}", (Object)dataSourceName);
        return this.readDataSources[index];
    }

    public Connection getConnection() throws SQLException {
        return this.determineDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.determineDataSource().getConnection(username, password);
    }
}

