/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.converter;

import cn.featherfly.common.lang.Lang;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public final class StringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        Class<T> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        if (enumType == null) {
            throw new IllegalArgumentException("The target type " + targetType.getName() + " does not refer to an enum");
        }
        return new StringToEnum<T>(enumType);
    }

    private class StringToEnum<T extends Enum<T>>
    implements Converter<String, T> {
        private final Class<T> enumType;

        public StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(String source) {
            if (Lang.isEmpty((String)source)) {
                return null;
            }
            return (T)Lang.toEnum(this.enumType, (Object)source);
        }
    }
}

