/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.converter;

import cn.featherfly.common.lang.Lang;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;

public final class StringToDateConverterFactory
implements ConverterFactory<String, Date> {
    private static final Logger LOG = LoggerFactory.getLogger(StringToDateConverterFactory.class);
    private String[] patterns = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy-MM-dd"};
    private List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    public StringToDateConverterFactory() {
        this.setPatterns(this.patterns);
    }

    public <T extends Date> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToDate(this.dateFormats);
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
        this.dateFormats.clear();
        for (String pattern : patterns) {
            this.dateFormats.add(new SimpleDateFormat(pattern));
        }
    }

    private class StringToDate<T extends Date>
    implements Converter<String, T> {
        private List<DateFormat> dateFormats;

        public StringToDate(List<DateFormat> dateFormats) {
            this.dateFormats = dateFormats;
        }

        public T convert(String source) {
            if (Lang.isEmpty((String)source)) {
                return null;
            }
            for (DateFormat format : this.dateFormats) {
                try {
                    return (T)format.parse(source);
                }
                catch (Exception e) {
                    LOG.debug(e.getMessage());
                }
            }
            return null;
        }
    }
}

