/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.cache;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.spring.cache.MulitiUniqueKeyCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;

public class MulitiUniqueKeyCacheManager
extends AbstractTransactionSupportingCacheManager {
    private CacheManager cacheManager;
    private MulitiUniqueKeyCache cache;
    private String cacheName;
    private String idCacheName;
    private String uniqueKeyCacheName;
    private Map<String, String> uniquePrefixPropertyMap;
    private String idKeyPrefix;
    private String idPropertyName;
    private Class<?> targetType;

    public MulitiUniqueKeyCache getCache() {
        return this.cache;
    }

    public void setCache(MulitiUniqueKeyCache cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getIdCacheName() {
        return this.idCacheName;
    }

    public void setIdCacheName(String idCacheName) {
        this.idCacheName = idCacheName;
    }

    public String getUniqueKeyCacheName() {
        return this.uniqueKeyCacheName;
    }

    public void setUniqueKeyCacheName(String uniqueKeyCacheName) {
        this.uniqueKeyCacheName = uniqueKeyCacheName;
    }

    public Map<String, String> getUniquePrefixPropertyMap() {
        return this.uniquePrefixPropertyMap;
    }

    public void setUniquePrefixPropertyMap(Map<String, String> uniquePrefixPropertyMap) {
        this.uniquePrefixPropertyMap = uniquePrefixPropertyMap;
    }

    public String getIdKeyPrefix() {
        return this.idKeyPrefix;
    }

    public void setIdKeyPrefix(String idKeyPrefix) {
        this.idKeyPrefix = idKeyPrefix;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public void setIdPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public Cache getCache(String name) {
        if (this.cacheName.equals(name)) {
            return this.cache;
        }
        return null;
    }

    protected Collection<? extends Cache> loadCaches() {
        AssertIllegalArgument.isNotEmpty((String)this.idCacheName, (String)"idCacheName");
        AssertIllegalArgument.isNotEmpty((String)this.uniqueKeyCacheName, (String)"idCacheName");
        Cache targetCache = this.cacheManager.getCache(this.idCacheName);
        Cache uniqueCache = this.cacheManager.getCache(this.uniqueKeyCacheName);
        AssertIllegalArgument.isNotEmpty((Object)targetCache, (String)"targetCache\u4e0d\u5b58\u5728");
        AssertIllegalArgument.isNotEmpty((Object)uniqueCache, (String)"uniqueCache\u4e0d\u5b58\u5728");
        this.cache = new MulitiUniqueKeyCache(this.cacheName, targetCache, uniqueCache, this.uniquePrefixPropertyMap, this.targetType, this.idKeyPrefix, this.idPropertyName);
        HashSet<MulitiUniqueKeyCache> caches = new HashSet<MulitiUniqueKeyCache>();
        caches.add(this.cache);
        return caches;
    }

    protected Cache decorateCache(Cache cache) {
        return this.isTransactionAware() ? new TransactionAwareCacheDecorator(cache instanceof TransactionAwareCacheDecorator ? ((TransactionAwareCacheDecorator)cache).getTargetCache() : cache) : cache;
    }
}

