/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.cache;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.spring.cache.CacheException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;

public class MulitiUniqueKeyCache
implements Cache {
    public static final String DEFAULT_ID_KEY_PREFIX = "MulitiUnique:id:";
    public static final String DEFAULT_ID_PROPERTY_NAME = "id";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private int targetNotFoundIdValue = Integer.MIN_VALUE;
    private Cache targetCache;
    private Cache targetUniqueKeyCache;
    private Map<String, String> uniquePrefixPropertyMap;
    private String idKeyPrefix;
    private String idPropertyName;
    private String name;
    private Class<?> targetType;

    public MulitiUniqueKeyCache(String name, Cache targetCache, Cache targetUniqueKeyCache, Map<String, String> uniquePrefixPropertyMap, Class<?> targetType) {
        this(name, targetCache, targetUniqueKeyCache, uniquePrefixPropertyMap, targetType, DEFAULT_ID_KEY_PREFIX, DEFAULT_ID_PROPERTY_NAME);
    }

    public MulitiUniqueKeyCache(String name, Cache targetCache, Cache targetUniqueKeyCache, Map<String, String> uniquePrefixPropertyMap, Class<?> targetType, String idKeyPrefix, String idPropertyName) {
        this.name = name;
        this.uniquePrefixPropertyMap = uniquePrefixPropertyMap;
        this.targetCache = targetCache;
        this.targetUniqueKeyCache = targetUniqueKeyCache;
        this.idKeyPrefix = idKeyPrefix;
        this.idPropertyName = idPropertyName;
        this.targetType = targetType;
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.targetCache.getNativeCache();
    }

    public Cache.ValueWrapper get(Object key) {
        if (this.isUnique(key)) {
            Cache.ValueWrapper id = this.targetUniqueKeyCache.get(key);
            this.logger.debug("find id[{}] unique key [{}]", (Object)id, key);
            if (id == null || id.get() == null) {
                return null;
            }
            if (id.get().equals(new Integer(this.targetNotFoundIdValue))) {
                return new SimpleValueWrapper(null);
            }
            return this.targetCache.get(id.get());
        }
        return this.targetCache.get(key);
    }

    public <T> T get(Object key, Class<T> type) {
        if (this.isUnique(key)) {
            Cache.ValueWrapper id = this.targetUniqueKeyCache.get(key);
            this.logger.debug("find id[{}] unique key [{}]", (Object)id, key);
            if (id == null) {
                return null;
            }
            return (T)this.targetCache.get((Object)id);
        }
        return (T)this.targetCache.get(key);
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        if (this.isUnique(key)) {
            Object id = this.targetUniqueKeyCache.get(key, valueLoader);
            this.logger.debug("find id[{}] unique key [{}]", id, key);
            if (id == null) {
                return null;
            }
            return (T)this.targetCache.get(id, valueLoader);
        }
        return (T)this.targetCache.get(key, valueLoader);
    }

    public void put(Object key, Object value) {
        this.assertSupportType(value);
        if (this.isUnique(key)) {
            if (value == null) {
                this.targetUniqueKeyCache.put(key, (Object)this.targetNotFoundIdValue);
            } else {
                Object id = BeanUtils.getProperty((Object)value, (String)this.idPropertyName);
                this.logger.debug("set id[{}] unique key [{}]", BeanUtils.getProperty((Object)value, (String)this.idPropertyName), key);
                this.putTarget(this.idKeyPrefix + id, value, id);
            }
        } else {
            this.putTarget(key, value, key);
        }
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        this.assertSupportType(value);
        if (this.isUnique(key)) {
            if (value == null) {
                return this.targetUniqueKeyCache.putIfAbsent(key, (Object)this.targetNotFoundIdValue);
            }
            Object id = BeanUtils.getProperty((Object)value, (String)this.idPropertyName);
            this.logger.debug("set id[{}] unique key [{}]", id, key);
            return this.putTargetIfAbsend(this.idKeyPrefix + id, value, id);
        }
        return this.putTargetIfAbsend(key, value, key);
    }

    private void putTarget(Object key, Object value, Object id) {
        if (value != null) {
            this.uniquePrefixPropertyMap.forEach((k, v) -> {
                Object uniqueValue = BeanUtils.getProperty((Object)value, (String)v);
                if (Lang.isNotEmpty((Object)uniqueValue)) {
                    this.targetUniqueKeyCache.put((Object)(k + uniqueValue), (Object)(this.idKeyPrefix + id));
                }
            });
        }
        this.targetCache.put(key, value);
    }

    private Cache.ValueWrapper putTargetIfAbsend(Object key, Object value, Object id) {
        if (value != null) {
            this.uniquePrefixPropertyMap.forEach((k, v) -> {
                Object uniqueValue = BeanUtils.getProperty((Object)value, (String)v);
                if (Lang.isNotEmpty((Object)uniqueValue)) {
                    this.targetUniqueKeyCache.putIfAbsent((Object)(k + uniqueValue), (Object)(this.idKeyPrefix + id));
                }
            });
        }
        return this.targetCache.putIfAbsent(key, value);
    }

    public void evict(Object key) {
        Object value;
        Object id;
        if (this.isUnique(key)) {
            id = (String)this.targetUniqueKeyCache.get(key, String.class);
            value = this.targetCache.get(id, this.targetType);
        } else {
            value = this.targetCache.get(key, this.targetType);
        }
        id = BeanUtils.getProperty((Object)value, (String)this.idPropertyName);
        this.targetCache.evict((Object)(this.idKeyPrefix + id));
        this.uniquePrefixPropertyMap.forEach((keyPrefix, propertyName) -> {
            Object uniqueValue = BeanUtils.getProperty((Object)value, (String)propertyName);
            this.targetUniqueKeyCache.evict((Object)(keyPrefix + uniqueValue));
        });
    }

    public void clear() {
        this.targetCache.clear();
        this.targetUniqueKeyCache.clear();
    }

    private boolean isUnique(Object key) {
        if (key != null && key instanceof String && this.uniquePrefixPropertyMap != null) {
            boolean result = false;
            for (String s : this.uniquePrefixPropertyMap.keySet()) {
                result = key.toString().startsWith(s);
                if (!result) continue;
                return result;
            }
        }
        return false;
    }

    private void assertSupportType(Class<?> type) {
        if (type != null && !ClassUtils.isParent(this.targetType, type)) {
            throw new CacheException(String.format("\u53ea\u652f\u6301%s\u7c7b\u578b\u7f13\u5b58\uff0c\u4f20\u5165\u7684\u7c7b\u578b%s\u4e0d\u652f\u6301", this.targetType.getName(), type.getName()));
        }
    }

    private void assertSupportType(Object value) {
        if (value != null) {
            this.assertSupportType(value.getClass());
        }
    }

    public Cache getTargetCache() {
        return this.targetCache;
    }

    public void setTargetCache(Cache targetCache) {
        this.targetCache = targetCache;
    }

    public Cache getTargetUniqueKeyCache() {
        return this.targetUniqueKeyCache;
    }

    public void setTargetUniqueKeyCache(Cache targetUniqueKeyCache) {
        this.targetUniqueKeyCache = targetUniqueKeyCache;
    }

    public Map<String, String> getUniquePrefixPropertyMap() {
        return this.uniquePrefixPropertyMap;
    }

    public void setUniquePrefixPropertyMap(Map<String, String> uniquePrefixPropertyMap) {
        this.uniquePrefixPropertyMap = uniquePrefixPropertyMap;
    }

    public String getIdKeyPrefix() {
        return this.idKeyPrefix;
    }

    public void setIdKeyPrefix(String idKeyPrefix) {
        this.idKeyPrefix = idKeyPrefix;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public void setIdPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public void setTargetType(Class<?> targetType) {
        this.targetType = targetType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getTargetNotFoundIdValue() {
        return this.targetNotFoundIdValue;
    }

    public void setTargetNotFoundIdValue(int targetNotFoundIdValue) {
        this.targetNotFoundIdValue = targetNotFoundIdValue;
    }
}

