/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.spring.cache;

import cn.featherfly.common.spring.cache.CacheException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;

public class MulitiCacheManager
extends AbstractTransactionSupportingCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulitiCacheManager.class);
    private List<CacheManager> cacheManagers;

    public List<CacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    public void setCacheManagers(List<CacheManager> cacheManagers) {
        if (cacheManagers == null) {
            cacheManagers = new ArrayList<CacheManager>();
        }
        this.cacheManagers = cacheManagers;
    }

    protected Collection<? extends Cache> loadCaches() {
        HashMap<String, Cache> cacheMap = new HashMap<String, Cache>();
        for (CacheManager cacheManager : this.cacheManagers) {
            for (String name : cacheManager.getCacheNames()) {
                Cache cache = cacheManager.getCache(name);
                if (cacheMap.containsKey(name)) {
                    throw new CacheException(String.format("muliti cache named %s, cachs[%s, %s]", name, ((Cache)cacheMap.get(name)).getClass().getName(), cache.getClass().getName()));
                }
                if (cache == null) continue;
                cacheMap.put(name, cache);
                LOGGER.debug("cache named {} in cacheManager[{}]", (Object)name, (Object)cacheManager.getClass().getName());
            }
        }
        return cacheMap.values();
    }

    protected Cache decorateCache(Cache cache) {
        return this.isTransactionAware() ? new TransactionAwareCacheDecorator(cache instanceof TransactionAwareCacheDecorator ? ((TransactionAwareCacheDecorator)cache).getTargetCache() : cache) : cache;
    }
}

