/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ClassPathScanningProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathScanningProvider.class);
    protected static final String DEFAULT_RESOURCE_PATTERN = "**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
    private String resourcePattern = "**/*.class";

    public void setResourcePattern(String resourcePattern) {
        AssertIllegalArgument.isNotNull((Object)resourcePattern, (String)"String resourcePattern");
        this.resourcePattern = resourcePattern;
    }

    public Set<MetadataReader> findMetadata(String basePackage) {
        LOGGER.debug("\u626b\u63cfbasePackage: " + basePackage);
        LinkedHashSet<MetadataReader> metaSet = new LinkedHashSet<MetadataReader>();
        try {
            Resource[] resources;
            String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + "/" + this.resourcePattern;
            for (Resource resource : resources = this.resourcePatternResolver.getResources(packageSearchPath)) {
                MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                metaSet.add(metadataReader);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("\u626b\u63cfclasspath\u65f6I/O\u5f02\u5e38", ex);
        }
        return metaSet;
    }

    public Set<MetadataReader> findMetadata(String ... basePackages) {
        LinkedHashSet<MetadataReader> metaSet = new LinkedHashSet<MetadataReader>();
        if (Lang.isNotEmpty((Object[])basePackages)) {
            LOGGER.debug("\u626b\u63cfbasePackages: " + ArrayUtils.toString((Object[])basePackages));
            for (String basePackage : basePackages) {
                metaSet.addAll(this.findMetadata(basePackage));
            }
        }
        return metaSet;
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }
}

