/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.mapping;

import cn.featherfly.common.bean.Property;
import cn.featherfly.common.repository.mapping.PrimaryKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;

public class PropertyMapping<P extends PropertyMapping<P>> {
    private int propertyIndex;
    private String propertyName;
    private String repositoryFieldName;
    private Class<? extends Serializable> propertyType;
    private PrimaryKey primaryKey;
    private String defaultValue;
    private Map<String, P> propertyMappings = new HashMap<String, P>(0);
    protected P parent;
    private int size;
    private String remark = "";
    private boolean nullable = true;
    private boolean insertable = true;
    private boolean updatable = true;
    private boolean unique;
    private boolean ignoreAtInsert;
    private Mode mode = Mode.SINGLE;
    private Property<Object, Serializable> property;
    private Function<Object, Serializable> getter;
    private BiConsumer<Object, Serializable> setter;
    private int decimalDigits;
    private boolean autoincrement;
    private int index = 0;

    public void setPropertyIndex(int propertyIndex) {
        this.propertyIndex = propertyIndex;
    }

    public int getPropertyIndex() {
        return this.propertyIndex;
    }

    public int[] getPropertyIndexes() {
        if (this.parent != null) {
            return ArrayUtils.addAll((int[])((PropertyMapping)this.parent).getPropertyIndexes(), (int[])new int[]{this.getPropertyIndex()});
        }
        return new int[]{this.getPropertyIndex()};
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    public Function<Object, Serializable> getGetter() {
        return this.getter;
    }

    public void setGetter(Function<Object, Serializable> getter) {
        this.getter = getter;
    }

    public BiConsumer<Object, Serializable> getSetter() {
        return this.setter;
    }

    public void setSetter(BiConsumer<Object, Serializable> setter) {
        this.setter = setter;
    }

    public Class<? extends Serializable> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<? extends Serializable> propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey != null;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String[] getPropertyNames() {
        if (this.parent != null) {
            return (String[])ArrayUtils.addAll((Object[])((PropertyMapping)this.parent).getPropertyNames(), (Object[])new String[]{this.getPropertyName()});
        }
        return new String[]{this.getPropertyName()};
    }

    public String getPropertyFullName() {
        if (this.parent != null) {
            return ((PropertyMapping)this.parent).getPropertyFullName() + "." + this.getPropertyName();
        }
        return this.getPropertyName();
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getRepositoryFieldName() {
        if (this.repositoryFieldName == null) {
            StringBuilder name = new StringBuilder();
            for (Map.Entry<String, P> entry : this.propertyMappings.entrySet()) {
                name.append(entry.getKey()).append(",");
            }
            if (name.length() > 0) {
                name.deleteCharAt(name.length() - 1);
            }
            return name.toString();
        }
        return this.repositoryFieldName;
    }

    public void setRepositoryFieldName(String repositoryFieldName) {
        this.repositoryFieldName = repositoryFieldName;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public P getParent() {
        return this.parent;
    }

    public List<P> getPropertyMappings() {
        return new ArrayList<P>(this.propertyMappings.values());
    }

    public P getPropertyMapping(String propertyName) {
        for (PropertyMapping pm : this.propertyMappings.values()) {
            if (!pm.getPropertyName().equals(propertyName)) continue;
            return (P)pm;
        }
        return null;
    }

    public P getPropertyMappingByPersitField(String repositoryFiledName) {
        return (P)((PropertyMapping)this.propertyMappings.get(repositoryFiledName));
    }

    public P add(P propertyMapping) {
        ((PropertyMapping)propertyMapping).parent = this;
        this.propertyMappings.put(((PropertyMapping)propertyMapping).getRepositoryFieldName(), propertyMapping);
        return (P)this;
    }

    public boolean isIgnoreAtInsert() {
        return this.ignoreAtInsert;
    }

    public void setIgnoreAtInsert(boolean ignoreAtInsert) {
        this.ignoreAtInsert = ignoreAtInsert;
    }

    public Property<Object, Serializable> getProperty() {
        return this.property;
    }

    public void setProperty(Property<Object, Serializable> property) {
        this.property = property;
    }

    public String toString() {
        return "PropertyMapping [propertyName=" + this.propertyName + ", repositoryFieldName=" + this.repositoryFieldName + ", propertyType=" + this.propertyType + ", primaryKey=" + this.primaryKey + ", defaultValue=" + this.defaultValue + ", mode=" + (Object)((Object)this.mode) + ", propertyMappings=" + this.propertyMappings + ", parent=" + (this.parent == null ? "" : ((PropertyMapping)this.parent).getPropertyName()) + "]";
    }

    public static enum Mode {
        SINGLE,
        EMBEDDED,
        MANY_TO_ONE,
        ONE_TO_MANY;

    }
}

