/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.mapping;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Index;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassMapping<T, P extends PropertyMapping<P>> {
    private Map<String, P> propertyMappings = new LinkedHashMap<String, P>(0);
    private Map<String, Index> indexs = new LinkedHashMap<String, Index>(0);
    private String repositoryName;
    private String remark;
    private String schema;
    private Class<T> type;

    public ClassMapping(Class<T> type, String repositoryName) {
        this(type, repositoryName, null);
    }

    public ClassMapping(Class<T> type, String repositoryName, String schema) {
        this(type, repositoryName, schema, null);
    }

    public ClassMapping(Class<T> type, String repositoryName, String schema, String remark) {
        this.type = type;
        this.repositoryName = repositoryName;
        this.schema = schema;
        this.remark = remark;
    }

    public P getPropertyMapping(String propertyName) {
        return (P)((PropertyMapping)this.propertyMappings.get(propertyName));
    }

    public P getPropertyMappingByPersitField(String persitField) {
        for (PropertyMapping pm : this.getPropertyMappingLeafNodes()) {
            if (!pm.getRepositoryFieldName().equals(persitField)) continue;
            return (P)pm;
        }
        return null;
    }

    public Collection<P> getPropertyMappings() {
        return new ArrayList<P>(this.propertyMappings.values());
    }

    public Collection<P> getPropertyMappingLeafNodes() {
        ArrayList<PropertyMapping> leafNodes = new ArrayList<PropertyMapping>();
        for (PropertyMapping propertyMapping : this.getPropertyMappings()) {
            if (propertyMapping.getPropertyMappings().size() > 0) {
                for (PropertyMapping pm : propertyMapping.getPropertyMappings()) {
                    leafNodes.add(pm);
                }
                continue;
            }
            leafNodes.add(propertyMapping);
        }
        return leafNodes;
    }

    public List<P> getPrimaryKeyPropertyMappings() {
        ArrayList<PropertyMapping> pks = new ArrayList<PropertyMapping>();
        for (PropertyMapping pk : this.propertyMappings.values().stream().filter(p -> p.isPrimaryKey()).collect(Collectors.toList())) {
            if (Lang.isEmpty(pk.getPropertyMappings())) {
                pks.add(pk);
                continue;
            }
            for (PropertyMapping spk : pk.getPropertyMappings()) {
                if (!spk.isPrimaryKey()) continue;
                pks.add(spk);
            }
        }
        return pks;
    }

    public void addPropertyMapping(P propertyMapping) {
        this.propertyMappings.put(((PropertyMapping)propertyMapping).getPropertyName(), propertyMapping);
    }

    public void addPropertyMappings(Collection<P> propertyMappings) {
        for (PropertyMapping propertyMapping : propertyMappings) {
            this.addPropertyMapping(propertyMapping);
        }
    }

    public void addIndex(Index index) {
        this.indexs.put(index.getName(), index);
    }

    public void addIndexs(Collection<Index> indexs) {
        for (Index index : indexs) {
            this.addIndex(index);
        }
    }

    public List<Index> getIndexs() {
        return new ArrayList<Index>(this.indexs.values());
    }

    public Index getIndex(String indexName) {
        return this.indexs.get(indexName);
    }

    public String toString() {
        return "ClassMapping [repositoryName=" + this.repositoryName + ", remark=" + this.remark + ", schema=" + this.schema + ", type=" + this.type + ", indexs=" + this.indexs + "propertyMappings=" + this.propertyMappings + "]";
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isPrimaryKeyAutoincrement() {
        return ((PropertyMapping)this.getPrimaryKeyPropertyMappings().get(0)).isAutoincrement();
    }

    public boolean isPrimaryKeyOrdered() {
        for (PropertyMapping pkm : this.getPrimaryKeyPropertyMappings()) {
            if (pkm.getPrimaryKey().isOrdered()) continue;
            return false;
        }
        return true;
    }
}

