/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.builder;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AliasManager {
    public static final AliasGeneretor DEFAULT_ALIAS_GENERETOR = (name, no) -> "_" + name + no;
    private Map<String, String> nameAlias = new LinkedHashMap<String, String>();
    private Map<String, Integer> nameAliasSize = new ConcurrentHashMap<String, Integer>(0);
    private AliasGeneretor aliasGeneretor;

    public AliasManager() {
        this(DEFAULT_ALIAS_GENERETOR);
    }

    public AliasManager(AliasGeneretor aliasGeneretor) {
        AssertIllegalArgument.isNotNull((Object)aliasGeneretor, (String)"aliasGeneretor");
        this.aliasGeneretor = aliasGeneretor;
    }

    public String put(String name) {
        int size = this.getNameSize(name);
        String alias = this.aliasGeneretor.apply(name, size);
        this.put(name, alias, size);
        return alias;
    }

    public AliasManager put(String name, String alias) {
        Integer size = this.nameAliasSize.get(name);
        if (size == null) {
            size = 0;
        }
        return this.put(name, alias, size);
    }

    public AliasManager put(Map<String, String> tableNames) {
        for (Map.Entry<String, String> e : tableNames.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
        return this;
    }

    private AliasManager put(String name, String alias, Integer size) {
        Integer n = size;
        Integer n2 = size = Integer.valueOf(size + 1);
        this.nameAliasSize.put(name, size);
        this.nameAlias.put(alias, name);
        return this;
    }

    private int getNameSize(String name) {
        Integer size = this.nameAliasSize.get(name);
        if (size == null) {
            return 0;
        }
        return size;
    }

    public String getName(String alias) {
        return this.nameAlias.get(alias);
    }

    public String getAlias(int index) {
        AssertIllegalArgument.isGe((Number)index, (Number)0, (String)"index");
        if (index >= this.nameAlias.size()) {
            throw new BuilderException(BuilderExceptionCode.createIndexOutOffBoundsNameAliasSizeCode(index, this.nameAlias.size()));
        }
        int size = 0;
        for (Map.Entry<String, String> entry : this.nameAlias.entrySet()) {
            if (size == index) {
                return entry.getKey();
            }
            ++size;
        }
        return null;
    }

    public String getAlias(String name) {
        int size = this.getNameSize(name);
        if (size > 1) {
            throw new BuilderException(BuilderExceptionCode.createMulitipleNameCode(name));
        }
        for (Map.Entry<String, String> entry : this.nameAlias.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<String, String> getNameAlias() {
        return this.nameAlias;
    }

    @FunctionalInterface
    public static interface AliasGeneretor {
        public String apply(String var1, int var2);
    }
}

