/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.builder;

import cn.featherfly.common.exception.SimpleLocalizedExceptionCode;
import java.util.Locale;

public class BuilderExceptionCode
extends SimpleLocalizedExceptionCode {
    private static final String MODULE = "BUILDER";

    public BuilderExceptionCode(Integer num, String key) {
        this(num, key, new Object[0]);
    }

    public BuilderExceptionCode(Integer num, String key, Object[] argus) {
        this(num, key, null, argus);
    }

    public BuilderExceptionCode(Integer num, String key, Locale locale) {
        this(num, key, locale, new Object[0]);
    }

    public BuilderExceptionCode(Integer num, String key, Locale locale, Object[] argus) {
        super(MODULE, num, key, locale, argus);
    }

    public static BuilderExceptionCode createQueryOperatorNullCode() {
        return new BuilderExceptionCode(BuilderExceptionCodes.BUILDER10000.num, BuilderExceptionCodes.BUILDER10000.key);
    }

    public static BuilderExceptionCode createNoConditionBehindCode(String operatorName) {
        return new BuilderExceptionCode(BuilderExceptionCodes.BUILDER10001.num, BuilderExceptionCodes.BUILDER10001.key, new Object[]{operatorName});
    }

    public static BuilderExceptionCode createNextToSameConditionCode(String conditionTypeName) {
        return new BuilderExceptionCode(BuilderExceptionCodes.BUILDER10003.num, BuilderExceptionCodes.BUILDER10003.key, new Object[]{conditionTypeName});
    }

    public static BuilderExceptionCode createIndexGtNameAliasSizeCode(Integer index, Integer size) {
        return new BuilderExceptionCode(BuilderExceptionCodes.BUILDER10004.num, BuilderExceptionCodes.BUILDER10004.key, new Object[]{index, size});
    }

    public static enum BuilderExceptionCodes {
        BUILDER10000("query_operator_null", 10000),
        BUILDER10001("no_condition_behind", 10001),
        BUILDER10003("next_to_same_condition", 10003),
        BUILDER10004("index_gt_name_alias_size", 10004);

        private String key;
        private Integer num;

        private BuilderExceptionCodes(String key, Integer num) {
            this.key = key;
            this.num = num;
        }

        public String getKey() {
            return this.key;
        }

        public Integer getNum() {
            return this.num;
        }
    }
}

