/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.builder;

import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AliasManager {
    private Map<String, String> nameAlias = new LinkedHashMap<String, String>();
    private Map<String, Integer> nameAliasSize = new ConcurrentHashMap<String, Integer>(0);

    public static String generateAlias(String name) {
        return "_" + name;
    }

    public String put(String name) {
        Integer size = this.nameAliasSize.get(name);
        if (size == null) {
            size = 0;
        }
        String alias = AliasManager.generateAlias(name) + size;
        this.put(name, alias, size);
        return alias;
    }

    public AliasManager put(String name, String alias) {
        Integer size = this.nameAliasSize.get(name);
        if (size == null) {
            size = 0;
        }
        return this.put(name, alias, size);
    }

    private AliasManager put(String name, String alias, Integer size) {
        Integer n = size;
        size = size + 1;
        this.nameAliasSize.put(name, size);
        this.nameAlias.put(alias, name);
        return this;
    }

    public String getName(String alias) {
        return this.nameAlias.get(alias);
    }

    public String getAlias(int index) {
        if (index > this.nameAlias.size()) {
            throw new BuilderException(BuilderExceptionCode.createIndexGtNameAliasSizeCode(index, this.nameAlias.size()));
        }
        int size = 0;
        for (Map.Entry<String, String> entry : this.nameAlias.entrySet()) {
            if (size == index) {
                return entry.getKey();
            }
            ++size;
        }
        return null;
    }

    public String getAlias(String name) {
        for (Map.Entry<String, String> entry : this.nameAlias.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }
}

