/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import java.util.Arrays;

public class Index {
    private String name;
    private String[] columns;
    private boolean unique;

    public Index(String[] columns) {
        this(null, columns, false);
    }

    public Index(String[] columns, boolean unique) {
        this(null, columns, unique);
    }

    public Index(String name, String[] columns, boolean unique) {
        AssertIllegalArgument.isNotEmpty((Object[])columns, (String)"columns");
        if (Lang.isEmpty((String)name)) {
            StringBuilder sb = new StringBuilder();
            for (String column : columns) {
                sb.append(column).append("_");
            }
            sb.append(unique ? "unique" : "index");
            this.name = sb.toString();
        } else {
            this.name = name;
        }
        this.columns = columns;
        this.unique = unique;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columns);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.unique ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Index other = (Index)obj;
        if (!Arrays.equals(this.columns, other.columns)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.unique == other.unique;
    }

    public String toString() {
        return "Index [name=" + this.name + ", columns=" + Arrays.toString(this.columns) + ", unique=" + this.unique + "]";
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public boolean isUnique() {
        return this.unique;
    }
}

