/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyMapping {
    private String propertyName;
    private String repositoryFieldName;
    private Class<?> propertyType;
    private boolean primaryKey;
    private String defaultValue;
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>(0);
    private PropertyMapping parent;
    private int size;
    private String remark;
    private boolean nullable;
    private boolean insertable = true;
    private boolean updatable = true;
    private boolean unique;
    private int decimalDigits;
    private boolean autoincrement;
    private int index = 0;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getRepositoryFieldName() {
        return this.repositoryFieldName;
    }

    public void setRepositoryFieldName(String repositoryFieldName) {
        this.repositoryFieldName = repositoryFieldName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public PropertyMapping getParent() {
        return this.parent;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return new ArrayList<PropertyMapping>(this.propertyMappings.values());
    }

    public PropertyMapping getPropertyMapping(String propertyName) {
        for (PropertyMapping pm : this.propertyMappings.values()) {
            if (!pm.getPropertyName().equals(propertyName)) continue;
            return pm;
        }
        return null;
    }

    public PropertyMapping getPropertyMappingByPersitField(String repositoryFiledName) {
        return this.propertyMappings.get(repositoryFiledName);
    }

    public PropertyMapping add(PropertyMapping propertyMapping) {
        propertyMapping.parent = this;
        this.propertyMappings.put(propertyMapping.getRepositoryFieldName(), propertyMapping);
        return this;
    }

    public String toString() {
        return "PropertyMapping [propertyName=" + this.propertyName + ", repositoryFieldName=" + this.repositoryFieldName + ", propertyType=" + this.propertyType + ", primaryKey=" + this.primaryKey + ", defaultValue=" + this.defaultValue + ", propertyMappings=" + this.propertyMappings + ", parent=" + this.parent + "]";
    }
}

