/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.repository.mapping;

import cn.featherfly.common.repository.mapping.PropertyMapping;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ClassMapping<T> {
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>(0);
    private String repositoryName;
    private String remark;
    private Class<?> type;

    public ClassMapping(Class<T> type, String repositoryName) {
        this(type, repositoryName, null);
    }

    public ClassMapping(Class<T> type, String repositoryName, String remark) {
        this.type = type;
        this.repositoryName = repositoryName;
        this.remark = remark;
    }

    public PropertyMapping getPropertyMapping(String propertyName) {
        return this.propertyMappings.get(propertyName);
    }

    public PropertyMapping getPropertyMappingByPersitField(String persitField) {
        for (PropertyMapping pm : this.propertyMappings.values()) {
            if (!pm.getRepositoryFieldName().equals(persitField)) continue;
            return pm;
        }
        return null;
    }

    public Collection<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings.values();
    }

    public List<PropertyMapping> getPrivaryKeyPropertyMappings() {
        return this.propertyMappings.values().stream().filter(p -> p.isPrimaryKey()).collect(Collectors.toList());
    }

    public void addPropertyMapping(PropertyMapping propertyMapping) {
        this.propertyMappings.put(propertyMapping.getPropertyName(), propertyMapping);
    }

    public void addPropertyMappings(Collection<PropertyMapping> propertyMappings) {
        for (PropertyMapping propertyMapping : propertyMappings) {
            this.addPropertyMapping(propertyMapping);
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String toString() {
        return "ClassMapping [repositoryName=" + this.repositoryName + ", type=" + this.type + ", propertyMappings=" + this.propertyMappings + "]";
    }

    public String getRemark() {
        return this.remark;
    }
}

