/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.api;

import javax.annotation.Nonnull;

public class Response<D> {
    public static final String SUCCESS_CODE = "OK";
    public static final String DEFAULT_ERROR_CODE = "ERROR";
    private D data;
    private String message;
    private String code;

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(this.code);
    }

    public static boolean isSuccess(Response<?> response) {
        if (response != null) {
            return response.isSuccess();
        }
        return false;
    }

    public static <D> Response<D> createSuccess(D data) {
        Response<D> response = new Response<D>();
        response.setData(data);
        response.setCode(SUCCESS_CODE);
        return response;
    }

    public static <D> Response<D> createFailure(@Nonnull String code, String message) {
        Response<D> response = new Response<D>();
        response.setCode(code);
        response.setMessage(message);
        return response;
    }

    public static <D> Response<D> createError(String message) {
        Response<D> response = new Response<D>();
        response.setCode(DEFAULT_ERROR_CODE);
        response.setMessage(message);
        return response;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public D getData() {
        return this.data;
    }

    public void setData(D data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

