/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.mail.client;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.UUIDGenerator;
import cn.featherfly.common.mail.MailAddress;
import cn.featherfly.common.mail.MailAttach;
import cn.featherfly.common.mail.MailBody;
import cn.featherfly.common.mail.MailException;
import cn.featherfly.common.mail.MailUser;
import cn.featherfly.common.mail.SmtpMailServer;
import cn.featherfly.common.mail.client.AbstractMailClient;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class MailSender
extends AbstractMailClient {
    public MailSender(MailUser mailUser, SmtpMailServer smtpServer) {
        this(mailUser, smtpServer, null);
    }

    public MailSender(MailUser mailUser, SmtpMailServer smtpServer, Map<String, Object> props) {
        super(mailUser, smtpServer, null, props);
        AssertIllegalArgument.isNotNull((Object)mailUser, (String)"mailUser");
        AssertIllegalArgument.isNotNull((Object)smtpServer, (String)"smtpServer");
    }

    public void send(String address, String subject, String content) {
        this.send(new MailAddress(address), new MailBody(subject, content));
    }

    public void send(MailAddress mailAddress, MailBody mailBody) {
        this.setDebug();
        try (Transport transport = this.getSession().getTransport(this.getSmtpServer().getProtocol());){
            Message message = this.createMessage(mailAddress, mailBody);
            transport.connect(this.getSmtpServer().getHost(), this.getSmtpServer().getPort(), this.getMailUser().getUsername(), this.getMailUser().getPassword());
            transport.sendMessage(message, message.getAllRecipients());
        }
        catch (MessagingException e) {
            throw new MailException(e);
        }
    }

    private Message createMessage(MailAddress mailAddress, MailBody mailBody) throws MessagingException {
        AssertIllegalArgument.isNotNull((Object)mailAddress, (String)"mailAddress");
        AssertIllegalArgument.isNotEmpty((Object[])mailAddress.getTo(), (String)"mailAddress.to");
        AssertIllegalArgument.isNotNull((Object)mailBody, (String)"mailBody");
        AssertIllegalArgument.isNotNull((Object)mailBody.getSubject(), (String)"mailBody.subject");
        MimeMessage message = new MimeMessage(this.getSession());
        message.setFrom((Address)new InternetAddress(this.getMailUser().getAddress()));
        if (mailBody.getSentDate() == null) {
            message.setSentDate(new Date());
        } else {
            message.setSentDate(mailBody.getSentDate());
        }
        message.addRecipients(Message.RecipientType.TO, this.getAddress(mailAddress.getTo()));
        if (mailAddress.isHasCC()) {
            message.addRecipients(Message.RecipientType.CC, this.getAddress(mailAddress.getCc()));
        }
        message.setSubject(this.encode(mailBody.getSubject()));
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart contentPart = new MimeBodyPart();
        if (mailBody.isMimeContent()) {
            contentPart.setContent((Object)mailBody.getContent(), "text/html;charset=" + this.getCharset());
        } else {
            contentPart.setText(mailBody.getContent(), this.getCharset());
        }
        multipart.addBodyPart((BodyPart)contentPart);
        if (mailBody.hasAttach()) {
            for (MailAttach mailAttach : mailBody.getMailAttachs()) {
                MimeBodyPart attachBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(mailAttach.getFile());
                attachBodyPart.setDataHandler(new DataHandler((DataSource)source));
                attachBodyPart.setFileName(this.encode(mailAttach.getFileName()));
                multipart.addBodyPart((BodyPart)attachBodyPart);
            }
        }
        message.setHeader("Message-Id", UUIDGenerator.generateUUID());
        for (Map.Entry entry : mailBody.getProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                message.setHeader("prop-" + (String)entry.getKey(), MimeUtility.encodeText((String)((String)entry.getValue()), (String)this.getCharset(), (String)this.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("\u53c2\u6570[{}]\u7f16\u7801\u51fa\u9519\uff1a{}", entry.getValue(), (Object)e.getMessage());
                message.setHeader("prop-" + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        return message;
    }

    private String encode(String str) {
        try {
            return MimeUtility.encodeText((String)str, (String)this.getCharset(), (String)this.getEncoding());
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u7801\u5b57\u7b26\u4e32\u65f6[{}]\u51fa\u9519\uff1a{}", (Object)str, (Object)e.getMessage());
            return str;
        }
    }
}

