/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.mail.client;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.mail.ImapMailServer;
import cn.featherfly.common.mail.MailApiUtils;
import cn.featherfly.common.mail.MailCreator;
import cn.featherfly.common.mail.MailException;
import cn.featherfly.common.mail.MailHandler;
import cn.featherfly.common.mail.MailUser;
import cn.featherfly.common.mail.Pop3MailServer;
import cn.featherfly.common.mail.client.AbstractMailClient;
import cn.featherfly.common.mail.client.MessageNumberGeTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.search.AndTerm;
import javax.mail.search.MessageIDTerm;
import javax.mail.search.SearchTerm;

public class MailReceiver
extends AbstractMailClient {
    private int allowCacheSize = -1;
    private String folder = "INBOX";

    public MailReceiver(MailUser mailUser, Pop3MailServer pop3MailServer) {
        this(mailUser, pop3MailServer, null);
    }

    public MailReceiver(MailUser mailUser, ImapMailServer imapMailServer) {
        this(mailUser, imapMailServer, null);
    }

    public MailReceiver(MailUser mailUser, Pop3MailServer pop3MailServer, Map<String, Object> props) {
        super(mailUser, null, pop3MailServer, props);
        AssertIllegalArgument.isNotNull((Object)mailUser, (String)"mailUser");
        AssertIllegalArgument.isNotNull((Object)pop3MailServer, (String)"smtpServer");
    }

    public MailReceiver(MailUser mailUser, ImapMailServer imapMailServer, Map<String, Object> props) {
        super(mailUser, null, imapMailServer, props);
        AssertIllegalArgument.isNotNull((Object)mailUser, (String)"mailUser");
        AssertIllegalArgument.isNotNull((Object)imapMailServer, (String)"smtpServer");
    }

    private <E> List<E> search(SearchTerm searchTerm, MailCreator<E> mailCreator) {
        AssertIllegalArgument.isNotNull(mailCreator, (String)"mailCreator");
        return this.search(searchTerm, 0, mailCreator, null);
    }

    public <E> E get(String messageId, MailCreator<E> mailCreator) {
        AssertIllegalArgument.isNotEmpty((String)messageId, (String)"messageId");
        List<E> list = this.search((SearchTerm)new MessageIDTerm(messageId), mailCreator);
        if (list.size() > 1) {
            this.logger.warn("get messageId -> {} size > 0 , size -> {}", (Object)messageId, (Object)list.size());
        }
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public <E> void receive(MailCreator<E> mailCreator, MailHandler<E> mailHandler) {
        this.receive(null, mailCreator, mailHandler);
    }

    public <E> void receive(SearchTerm searchTerm, MailCreator<E> mailCreator, MailHandler<E> mailHandler) {
        AssertIllegalArgument.isNotNull(mailCreator, (String)"mailCreator");
        AssertIllegalArgument.isNotNull(mailHandler, (String)"mailHandler");
        this.search(searchTerm, 0, mailCreator, mailHandler);
    }

    private <E> List<E> search(SearchTerm searchTerm, int start, MailCreator<E> mailCreator, MailHandler<E> handler) {
        AssertIllegalArgument.isNotNull(mailCreator, (String)"mailCreator");
        Store store = null;
        try {
            store = this.getStore();
            List<E> list = this.searchInStore(searchTerm, start, store, mailCreator, handler);
            return list;
        }
        catch (Exception e) {
            throw new MailException(e);
        }
        finally {
            MailApiUtils.close(store, this.logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <E> List<E> searchInStore(SearchTerm searchTerm, int start, Store store, MailCreator<E> mailCreator, MailHandler<E> handler) throws Exception {
        block9: {
            AssertIllegalArgument.isNotNull(mailCreator, (String)"mailCreator");
            folder = null;
            cacheSize = 0;
            try {
                mails = new ArrayList<E>();
                folder = this.getFolder(store);
                folder.open(1);
                messages = null;
                messages = searchTerm == null ? this.searchMessages(folder, (SearchTerm)new MessageNumberGeTerm(start)) : this.searchMessages(folder, (SearchTerm)new AndTerm(searchTerm, (SearchTerm)new MessageNumberGeTerm(start)));
                i = 0;
                n = messages.length;
lbl12:
                // 2 sources

                while (i < n) {
                    message = messages[i];
                    messageSize = message.getSize();
                    cacheSize += messageSize;
                    if (this.allowCacheSize > 0 && messageSize > this.allowCacheSize) {
                        throw new MailException("#mail.size.gt.cache", new Object[]{messageSize, this.allowCacheSize});
                    }
                    if (this.allowCacheSize > 0 && cacheSize > this.allowCacheSize) {
                        this.logger.debug("\u4ece\u7b2c[{}]\u5c01\u90ae\u4ef6\u5f00\u59cb\uff0c\u5728\u7b2c{}\u5c01\u90ae\u4ef6\u65f6\u7d2f\u8ba1\u7f13\u5b58[{}]\u8d85\u8fc7\u5141\u8bb8\u7684\u7f13\u5b58[{}]\u5927\u5c0f\uff0c\u91cd\u65b0\u8fde\u63a5", new Object[]{start, i, cacheSize, this.allowCacheSize});
                        MailApiUtils.close(folder, false, this.logger);
                        mails.addAll(this.searchInStore(searchTerm, start + i, store, mailCreator, handler));
                        var14_15 = mails;
                        break block9;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl42
            }
            catch (Throwable var15_16) {
                MailApiUtils.close(folder, false, this.logger);
                throw var15_16;
            }
        }
        MailApiUtils.close(folder, false, this.logger);
        return var14_15;
lbl-1000:
        // 1 sources

        {
            if (message != null) {
                mail = mailCreator.create(message);
                if (handler != null) {
                    handler.handle(mail);
                } else {
                    mails.add(mail);
                }
            }
            ++i;
            ** GOTO lbl12
lbl42:
            // 1 sources

            var10_11 = mails;
        }
        MailApiUtils.close(folder, false, this.logger);
        return var10_11;
    }

    public void delete(String messageId) {
        this.flag(messageId, new Flags(Flags.Flag.DELETED));
    }

    public void seen(String messageId) {
        this.flag(messageId, new Flags(Flags.Flag.SEEN));
    }

    public void answer(String messageId) {
        this.flag(messageId, new Flags(Flags.Flag.ANSWERED));
    }

    public void recent(String messageId) {
        this.flag(messageId, new Flags(Flags.Flag.RECENT));
    }

    public void flag(String messageId, String flag) {
        this.flag(messageId, new Flags(flag));
    }

    private void flag(String messageId, Flags flags) {
        Store store = null;
        Folder folder = null;
        try {
            MessageIDTerm searchTerm = new MessageIDTerm(messageId);
            store = this.getStore();
            folder = this.getFolder(store);
            folder.open(2);
            for (Message message : this.searchMessages(folder, (SearchTerm)searchTerm)) {
                message.setFlags(flags, true);
            }
        }
        catch (Exception e) {
            try {
                throw new MailException(e);
            }
            catch (Throwable throwable) {
                MailApiUtils.close(folder, false, this.logger);
                MailApiUtils.close(store, this.logger);
                throw throwable;
            }
        }
        MailApiUtils.close(folder, false, this.logger);
        MailApiUtils.close(store, this.logger);
    }

    private Message[] searchMessages(Folder folder, SearchTerm searchTerm) throws MessagingException {
        Message[] messages = null;
        messages = searchTerm == null ? folder.getMessages() : folder.search(searchTerm);
        return messages;
    }

    private Store getStore() throws MessagingException {
        Store store = this.getSession().getStore(this.getStoreServer().getProtocol());
        store.connect(this.getStoreServer().getHost(), this.getStoreServer().getPort(), this.getMailUser().getUsername(), this.getMailUser().getPassword());
        return store;
    }

    private Folder getFolder(Store store) throws MessagingException {
        AssertIllegalArgument.isNotEmpty((String)this.folder, (String)"folder");
        Folder folder = store.getFolder(this.folder);
        return folder;
    }

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public int getAllowCacheSize() {
        return this.allowCacheSize;
    }

    public void setAllowCacheSize(int allowCacheSize) {
        this.allowCacheSize = allowCacheSize;
    }
}

