/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.mail.client;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.StringUtils;
import cn.featherfly.common.mail.ImapMailServer;
import cn.featherfly.common.mail.MailException;
import cn.featherfly.common.mail.MailServer;
import cn.featherfly.common.mail.MailUser;
import cn.featherfly.common.mail.Pop3MailServer;
import cn.featherfly.common.mail.SmtpMailServer;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailClient {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    protected static final String MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String PROPERTY_PREFIX = "prop-";
    private Session session;
    private MailUser mailUser;
    private MailServer smtpServer;
    private MailServer storeServer;
    private Map<String, Object> props = new HashMap<String, Object>();
    private String charset = "GBK";
    private String encoding = "B";
    private String mailSmtpHost;
    private String mailSmtpAuth;
    private boolean debug;
    private String mailLogFile;

    public AbstractMailClient(MailUser mailUser, SmtpMailServer smtpMailServer) {
        this(mailUser, smtpMailServer, null);
    }

    public AbstractMailClient(MailUser mailUser, Pop3MailServer pop3MailServer) {
        this(mailUser, null, pop3MailServer);
    }

    public AbstractMailClient(MailUser mailUser, ImapMailServer imapMailServer) {
        this(mailUser, null, imapMailServer);
    }

    public AbstractMailClient(MailUser mailUser, MailServer smtpServer, MailServer storeServer) {
        this(mailUser, smtpServer, storeServer, null);
    }

    public AbstractMailClient(MailUser mailUser, MailServer smtpServer, MailServer storeServer, Map<String, Object> props) {
        try {
            this.init(mailUser, smtpServer, storeServer, props);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    public AbstractMailClient(AbstractMailClient mailClient) {
        this(mailClient.mailUser, mailClient.smtpServer, mailClient.storeServer);
        this.setCharset(mailClient.charset);
        this.setDebug(mailClient.debug);
        this.setEncoding(mailClient.encoding);
        this.setMailLogFile(mailClient.mailLogFile);
        this.setMailSmtpAuth(mailClient.mailSmtpAuth);
        this.setMailSmtpHost(mailClient.mailSmtpHost);
    }

    protected void init(final MailUser mailUser, MailServer smtpServer, MailServer storeServer, Map<String, Object> props) throws MessagingException {
        Properties properties = new Properties();
        AssertIllegalArgument.isNotNull((Object)mailUser, (String)"mailUser");
        this.mailUser = mailUser;
        this.smtpServer = smtpServer;
        this.storeServer = storeServer;
        if (smtpServer != null) {
            properties.put(this.getMailSmtpHost(), smtpServer.getHost());
            properties.put(this.getMailSmtpAuth(), "true");
            properties.put("mail.smtp.port", (Object)smtpServer.getPort());
        }
        if (storeServer != null) {
            properties.put("mail.store.protocol", storeServer.getProtocol());
            properties.put("mail." + storeServer.getProtocol() + ".host", storeServer.getHost());
        }
        this.session = Session.getDefaultInstance((Properties)properties, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(mailUser.getAddress(), mailUser.getPassword());
            }
        });
    }

    protected Address[] getAddress(String[] address) throws AddressException {
        InternetAddress[] addrs = new InternetAddress[address.length];
        for (int i = 0; i < address.length; ++i) {
            addrs[i] = new InternetAddress(address[i]);
        }
        return addrs;
    }

    protected void setDebug() {
        if (this.debug) {
            if (StringUtils.isNotEmpty((String)this.mailLogFile)) {
                try {
                    this.session.setDebugOut(new PrintStream(new FileOutputStream(this.mailLogFile, true)));
                }
                catch (FileNotFoundException e) {
                    this.logger.warn("\u90ae\u4ef6\u53d1\u9001\u65e5\u5fd7\u6587\u4ef6\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            } else {
                this.session.setDebug(this.debug);
            }
        }
    }

    protected Session getSession() {
        return this.session;
    }

    protected MailServer getSmtpServer() {
        return this.smtpServer;
    }

    protected MailServer getStoreServer() {
        return this.storeServer;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getMailSmtpHost() {
        if (StringUtils.isBlank((CharSequence)this.mailSmtpHost)) {
            this.mailSmtpHost = MAIL_SMTP_HOST;
        }
        return this.mailSmtpHost;
    }

    public void setMailSmtpHost(String mailSmtpHost) {
        this.mailSmtpHost = mailSmtpHost;
    }

    public String getMailSmtpAuth() {
        if (StringUtils.isBlank((CharSequence)this.mailSmtpAuth)) {
            this.mailSmtpAuth = MAIL_SMTP_AUTH;
        }
        return this.mailSmtpAuth;
    }

    public void setMailSmtpAuth(String mailSmtpAuth) {
        this.mailSmtpAuth = mailSmtpAuth;
    }

    public String getMailLogFile() {
        return this.mailLogFile;
    }

    public void setMailLogFile(String mailLogFile) {
        this.mailLogFile = mailLogFile;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public MailUser getMailUser() {
        return this.mailUser;
    }
}

