/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.mail;

import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.UUIDGenerator;
import cn.featherfly.common.mail.Mail;
import cn.featherfly.common.mail.MailAddress;
import cn.featherfly.common.mail.MailAttach;
import cn.featherfly.common.mail.MailBody;
import cn.featherfly.common.mail.MailCreator;
import cn.featherfly.common.mail.MailException;
import cn.featherfly.common.mail.MailUser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMailCreator
implements MailCreator<Mail> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMailCreator.class);

    @Override
    public Mail create(Message message) {
        try {
            return this.createMail(message);
        }
        catch (Exception e) {
            throw new MailException(e);
        }
    }

    private Mail createMail(Message message) throws MessagingException, IOException {
        Mail mail = new Mail();
        mail.setMailAddress(new MailAddress(new String[0]));
        mail.setMailUser(new MailUser("", ""));
        mail.setMailBody(new MailBody(null, null, true));
        Object[] headerId = message.getHeader("Message-ID");
        if (LangUtils.isNotEmpty((Object[])headerId)) {
            mail.setId((String)headerId[0]);
        } else {
            LOGGER.warn("\u6ca1\u6709\u627e\u5230Message-ID");
        }
        LOGGER.trace("Message-ID : {}", (Object)mail.getId());
        mail.getMailBody().setSentDate(message.getSentDate());
        mail.getMailBody().setReceivedDate(message.getReceivedDate());
        LOGGER.trace("SentDate : {}", (Object)message.getSentDate());
        LOGGER.trace("ReceivedDate : {}", (Object)message.getReceivedDate());
        Address[] toAddresses = message.getRecipients(Message.RecipientType.TO);
        if (toAddresses != null) {
            String[] to = new String[toAddresses.length];
            for (int i = 0; i < toAddresses.length; ++i) {
                if (toAddresses[i] instanceof InternetAddress) {
                    InternetAddress toAddress = (InternetAddress)toAddresses[i];
                    to[i] = toAddress.getAddress();
                    continue;
                }
                to[i] = toAddresses[i].toString();
            }
            mail.getMailAddress().setTo(to);
        }
        LOGGER.trace("toAddresses : {}", (Object)Arrays.toString(mail.getMailAddress().getTo()));
        Address[] ccAddresses = message.getRecipients(Message.RecipientType.CC);
        if (ccAddresses != null) {
            String[] cc = new String[ccAddresses.length];
            for (int i = 0; i < ccAddresses.length; ++i) {
                if (ccAddresses[i] instanceof InternetAddress) {
                    InternetAddress ccAddress = (InternetAddress)ccAddresses[i];
                    cc[i] = ccAddress.getAddress();
                    continue;
                }
                cc[i] = ccAddresses[i].toString();
            }
            mail.getMailAddress().setCc(cc);
        }
        LOGGER.trace("ccAddresses : {}", (Object)Arrays.toString(mail.getMailAddress().getCc()));
        if (message.getFrom()[0] instanceof InternetAddress) {
            InternetAddress address = (InternetAddress)message.getFrom()[0];
            mail.getMailUser().setAddress(address.getAddress());
        } else {
            mail.getMailUser().setAddress(message.getFrom()[0].toString());
        }
        LOGGER.trace("from : {}", (Object)mail.getMailUser().getAddress());
        mail.getMailBody().setSubject(message.getSubject());
        LOGGER.trace("subject : {}", (Object)mail.getMailBody().getSubject());
        String flags = "";
        for (Flags.Flag f : message.getFlags().getSystemFlags()) {
            if (f == Flags.Flag.ANSWERED) {
                flags = flags + "ANSWERED,";
                continue;
            }
            if (f == Flags.Flag.DELETED) {
                flags = flags + "DELETED,";
                continue;
            }
            if (f == Flags.Flag.DRAFT) {
                flags = flags + "DRAFT,";
                continue;
            }
            if (f == Flags.Flag.FLAGGED) {
                flags = flags + "FLAGGED,";
                continue;
            }
            if (f == Flags.Flag.RECENT) {
                flags = flags + "RECENT,";
                continue;
            }
            if (f == Flags.Flag.SEEN) {
                flags = flags + "SEEN,";
                continue;
            }
            if (f != Flags.Flag.USER) continue;
            flags = flags + "USER,";
        }
        LOGGER.trace("flags : {}", (Object)flags);
        LOGGER.trace("userFlags : {}", (Object)Arrays.toString(message.getFlags().getUserFlags()));
        Enumeration enums = message.getAllHeaders();
        while (enums.hasMoreElements()) {
            Header header = (Header)enums.nextElement();
            if (!header.getName().contains("prop-")) continue;
            String name = header.getName().substring("prop-".length());
            if (header.getValue() == null) continue;
            mail.getMailBody().setProperty(name, MimeUtility.decodeText((String)header.getValue()));
        }
        this.setContent(message, mail);
        LOGGER.trace("content : {}", (Object)mail.getMailBody().getContent());
        LOGGER.trace("attach_size : {}", (Object)mail.getMailBody().getMailAttachs().size());
        return mail;
    }

    private void setContent(Message message, Mail mail) throws IOException, MessagingException {
        if (message.getContent() instanceof MimeMultipart) {
            this.setContent((MimeMultipart)message.getContent(), mail);
        } else if (message.getContent() instanceof String) {
            if (message.getContentType().contains("text/html")) {
                mail.getMailBody().setContentHtml(message.getContent().toString());
            }
            mail.getMailBody().setContent(message.getContent().toString());
        } else {
            throw new MailException("\u90ae\u4ef6\u6b63\u6587\u4e0d\u662fMimeMultipart\u548cString\u7c7b\u578b\uff0c\u7c7b\u578b" + message.getContent().getClass().getName());
        }
    }

    private void setContent(MimeMultipart part, Mail mail) throws FileNotFoundException, IOException, MessagingException {
        for (int i = 0; i < part.getCount(); ++i) {
            BodyPart bodyPart = part.getBodyPart(i);
            String disposition = bodyPart.getDisposition();
            if (disposition != null && (disposition.equals("attachment") || disposition.equals("inline"))) {
                mail.getMailBody().addMailAttach(new MailAttach(this.storeAttach(bodyPart.getInputStream()), MimeUtility.decodeText((String)bodyPart.getFileName())));
                continue;
            }
            Object content = bodyPart.getContent();
            if (content instanceof MimeMultipart) {
                MimeMultipart subpart = (MimeMultipart)content;
                this.setContent(subpart, mail);
                continue;
            }
            if (content instanceof InputStream) {
                InputStream is = (InputStream)part.getBodyPart(i).getContent();
                mail.getMailBody().addMailAttach(new MailAttach(this.storeAttach(is), MimeUtility.decodeText((String)bodyPart.getFileName())));
                continue;
            }
            if (content instanceof String) {
                if (bodyPart.getContentType().contains("text/html")) {
                    mail.getMailBody().setContentHtml(content.toString());
                }
                mail.getMailBody().setContent(content.toString());
                continue;
            }
            throw new MailException("\u4e0d\u652f\u6301\u90ae\u4ef6\u6b63\u6587\u7c7b\u578b\uff1a" + content.getClass().getName());
        }
    }

    protected File storeAttach(InputStream is) throws IOException {
        File file = new File(UUIDGenerator.generateUUID());
        IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(file));
        return file;
    }
}

