/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.mail;

import cn.featherfly.common.mail.MailAttach;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MailBody {
    private String subject;
    private String content;
    private String contentHtml;
    private boolean mimeContent;
    private Date sentDate;
    private Date receivedDate;
    private String[] flags;
    private Map<String, String> properties = new HashMap<String, String>();
    private List<MailAttach> mailAttachs = new ArrayList<MailAttach>();

    public MailBody(String subject, String content) {
        this(subject, content, false);
    }

    public MailBody(String subject, String content, boolean mimeContent) {
        this(subject, content, mimeContent, new MailAttach[0]);
    }

    public MailBody(String subject, String content, boolean mimeContent, MailAttach ... mailAttachs) {
        this.subject = subject;
        this.content = content;
        this.mimeContent = mimeContent;
        this.addMailAttachs(mailAttachs);
    }

    public void addMailAttach(MailAttach mailAttach) {
        if (mailAttach != null) {
            this.mailAttachs.add(mailAttach);
        }
    }

    public void addMailAttachs(MailAttach ... mailAttachs) {
        if (mailAttachs != null) {
            for (MailAttach mailAttach : mailAttachs) {
                this.addMailAttach(mailAttach);
            }
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isMimeContent() {
        return this.mimeContent;
    }

    public void setMimeContent(boolean mimeContent) {
        this.mimeContent = mimeContent;
    }

    public boolean hasAttach() {
        return !this.mailAttachs.isEmpty();
    }

    public List<MailAttach> getMailAttachs() {
        return this.mailAttachs;
    }

    public String getContentHtml() {
        return this.contentHtml;
    }

    public void setContentHtml(String contentHtml) {
        this.contentHtml = contentHtml;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public Date getReceivedDate() {
        return this.receivedDate;
    }

    public void setReceivedDate(Date receivedDate) {
        this.receivedDate = receivedDate;
    }

    public String[] getFlags() {
        return this.flags;
    }

    public void setFlags(String[] flags) {
        this.flags = flags;
    }
}

