/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.algorithm.AlgorithmException;
import cn.featherfly.common.algorithm.URL;
import cn.featherfly.common.http.UploadFile;
import cn.featherfly.common.lang.Lang;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class HttpUtils {
    public static final String HTML_CONTENT_TYPE = "text/html; charset=utf-8";
    public static final MediaType HTML_MEDIA_TYPE = MediaType.parse((String)"text/html; charset=utf-8");
    public static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    public static final MediaType JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String XML_CONTENT_TYPE = "application/xml; charset=utf-8";
    public static final MediaType XML_MEDIA_TYPE = MediaType.parse((String)"application/xml; charset=utf-8");
    public static final String KRYO_CONTENT_TYPE = "application/kryo; charset=utf-8";
    public static final MediaType KRYO_MEDIA_TYPE = MediaType.parse((String)"application/kryo; charset=utf-8");
    public static final String PROTOBUFF_CONTENT_TYPE = "application/protobuff; charset=utf-8";
    public static final MediaType PROTOBUFF_MEDIA_TYPE = MediaType.parse((String)"application/protobuff; charset=utf-8");

    public static FormBody createFormBody(Map<String, Serializable> params) {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (Lang.isNotEmpty(params)) {
            for (Map.Entry<String, Serializable> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                formBodyBuilder.addEncoded(entry.getKey(), entry.getValue().toString());
            }
        }
        return formBodyBuilder.build();
    }

    public static RequestBody createRequestBody(Map<String, Serializable> params) {
        boolean isMultipar = false;
        if (Lang.isNotEmpty(params)) {
            for (Serializable value : params.values()) {
                if (!(value instanceof UploadFile)) continue;
                isMultipar = true;
                break;
            }
            if (isMultipar) {
                MultipartBody.Builder multiparBuilder = new MultipartBody.Builder();
                if (Lang.isNotEmpty(params)) {
                    for (Map.Entry<String, Serializable> entry : params.entrySet()) {
                        Serializable value = entry.getValue();
                        if (value == null) continue;
                        if (value instanceof UploadFile) {
                            UploadFile uploadFile = (UploadFile)value;
                            try {
                                multiparBuilder.addFormDataPart(entry.getKey(), URL.encodeURL((String)uploadFile.getFilename()), RequestBody.create((MediaType)MediaType.parse((String)uploadFile.getMediaType()), (byte[])uploadFile.getContent()));
                            }
                            catch (AlgorithmException e) {
                                multiparBuilder.addFormDataPart(entry.getKey(), uploadFile.getFilename(), RequestBody.create((MediaType)MediaType.parse((String)uploadFile.getMediaType()), (byte[])uploadFile.getContent()));
                            }
                            continue;
                        }
                        multiparBuilder.addFormDataPart(entry.getKey(), value.toString());
                    }
                }
                return multiparBuilder.build();
            }
        }
        return HttpUtils.createFormBody(params);
    }

    public static Map<String, String> headersToMap(Headers headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String name : headers.names()) {
            headerMap.put(name, headers.get(name));
        }
        return headerMap;
    }

    public static Headers createHeaders(Map<String, String> headers) {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static Headers createHeaders(Map<String, String> headers, Map<String, String> defaultHeaders) {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, String> entry : defaultHeaders.entrySet()) {
            if (headers.containsKey(entry.getKey())) continue;
            builder.add(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static String toParameString(Map<String, Serializable> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Serializable> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String appendParam(String url, String name, Serializable value) {
        String uri = url;
        if (Lang.isNotEmpty((String)uri)) {
            uri = uri.contains("?") ? uri + "&" : uri + "?";
            uri = uri + name + "=" + value;
        }
        return uri;
    }

    public static String appendParams(String url, Map<String, Serializable> params) {
        if (Lang.isNotEmpty(params)) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + HttpUtils.toParameString(params);
        }
        return url;
    }
}

