/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.AbstractHttpClient;
import cn.featherfly.common.http.HttpAsyncClient;
import cn.featherfly.common.http.HttpClient;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequestCompletion;
import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpRxjavaClient;
import cn.featherfly.common.serialization.Serialization;
import io.reactivex.rxjava3.core.Observable;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;

public class HttpClients
extends AbstractHttpClient {
    private HttpClient client;
    private HttpAsyncClient asyncClient;
    private HttpRxjavaClient rxjavaClient;

    public HttpClients() {
    }

    public HttpClients(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(config, headers, serialization, mediaType);
    }

    public HttpClients(HttpRequestConfig config, Map<String, String> headers) {
        super(config, headers);
    }

    public HttpClients(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        super(config, serialization, mediaType);
    }

    public HttpClients(HttpRequestConfig config) {
        super(config);
    }

    public HttpClients(Map<String, String> headers) {
        super(headers);
    }

    public HttpClients(OkHttpClient okhttpClient, Map<String, String> headers) {
        super(okhttpClient, headers);
    }

    public HttpClients(OkHttpClient okhttpClient, Serialization serialization, MediaType mediaType) {
        super(okhttpClient, serialization, mediaType);
    }

    public HttpClients(OkHttpClient okhttpClient, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(okhttpClient, headers, serialization, mediaType);
    }

    @Override
    protected void init(OkHttpClient okhttpClient, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super.init(okhttpClient, headers, serialization, mediaType);
        this.client = new HttpClient(okhttpClient, headers, serialization, mediaType);
        this.asyncClient = new HttpAsyncClient(okhttpClient, headers, serialization, mediaType);
        this.rxjavaClient = new HttpRxjavaClient(okhttpClient, headers, serialization, mediaType);
    }

    public boolean isAutoSubscribeOnIo() {
        return this.rxjavaClient.isAutoSubscribeOnIo();
    }

    public void setAutoSubscribeOnIo(boolean autoSubscribeOnIo) {
        this.rxjavaClient.setAutoSubscribeOnIo(autoSubscribeOnIo);
    }

    public String request(HttpMethod httpMethod, String url) {
        return this.client.request(httpMethod, url);
    }

    public String request(HttpMethod httpMethod, String url, Map<String, Serializable> params) {
        return this.client.request(httpMethod, url, params);
    }

    public String request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.request(httpMethod, url, params, headers);
    }

    public <R> R request(HttpMethod httpMethod, String url, Class<R> responseType) {
        return this.client.request(httpMethod, url, responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.request(httpMethod, url, params, responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.request(httpMethod, url, params, headers, responseType);
    }

    public String request(HttpMethod httpMethod, String url, Object requestBody) {
        return this.client.request(httpMethod, url, requestBody);
    }

    public String request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers) {
        return this.client.request(httpMethod, url, requestBody, headers);
    }

    public <R> R request(HttpMethod httpMethod, String url, Object requestBody, Class<R> responseType) {
        return this.client.request(httpMethod, url, requestBody, responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.client.request(httpMethod, url, requestBody, headers, responseType);
    }

    public HttpRequestCompletion<String> requestCompletion(HttpMethod httpMethod, String url) {
        return this.asyncClient.request(httpMethod, url);
    }

    public HttpRequestCompletion<String> requestCompletion(HttpMethod httpMethod, String url, Map<String, Serializable> params) {
        return this.asyncClient.request(httpMethod, url, params);
    }

    public HttpRequestCompletion<String> requestCompletion(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.request(httpMethod, url, params, headers);
    }

    public <R> HttpRequestCompletion<R> requestCompletion(HttpMethod httpMethod, String url, Class<R> responseType) {
        return this.asyncClient.request(httpMethod, url, responseType);
    }

    public <R> HttpRequestCompletion<R> requestCompletion(HttpMethod httpMethod, String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.request(httpMethod, url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> requestCompletion(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.request(httpMethod, url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> requestCompletion(HttpMethod httpMethod, String url, Object requestBody) {
        return this.asyncClient.request(httpMethod, url, requestBody);
    }

    public HttpRequestCompletion<String> requestCompletion(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers) {
        return this.asyncClient.request(httpMethod, url, requestBody, headers);
    }

    public <R> HttpRequestCompletion<R> requestCompletion(HttpMethod httpMethod, String url, Object requestBody, Class<R> responseType) {
        return this.asyncClient.request(httpMethod, url, requestBody, responseType);
    }

    public <R> HttpRequestCompletion<R> requestCompletion(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.request(httpMethod, url, requestBody, headers, responseType);
    }

    public Observable<String> requestObservable(HttpMethod httpMethod, String url) {
        return this.rxjavaClient.request(httpMethod, url);
    }

    public Observable<String> requestObservable(HttpMethod httpMethod, String url, Map<String, Serializable> params) {
        return this.rxjavaClient.request(httpMethod, url, params);
    }

    public Observable<String> requestObservable(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.request(httpMethod, url, params, headers);
    }

    public <R> Observable<R> requestObservable(HttpMethod httpMethod, String url, Class<R> responseType) {
        return this.rxjavaClient.request(httpMethod, url, responseType);
    }

    public <R> Observable<R> requestObservable(HttpMethod httpMethod, String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.request(httpMethod, url, params, responseType);
    }

    public <R> Observable<R> requestObservable(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.request(httpMethod, url, params, headers, responseType);
    }

    public Observable<String> requestObservable(HttpMethod httpMethod, String url, Object requestBody) {
        return this.rxjavaClient.request(httpMethod, url, requestBody);
    }

    public Observable<String> requestObservable(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers) {
        return this.rxjavaClient.request(httpMethod, url, requestBody, headers);
    }

    public <R> Observable<R> requestObservable(HttpMethod httpMethod, String url, Object requestBody, Class<R> responseType) {
        return this.rxjavaClient.request(httpMethod, url, requestBody, responseType);
    }

    public <R> Observable<R> requestObservable(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.request(httpMethod, url, requestBody, headers, responseType);
    }

    public String get(String url) {
        return this.client.get(url);
    }

    public String get(String url, Map<String, Serializable> params) {
        return this.client.get(url, params);
    }

    public String get(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.get(url, params, headers);
    }

    public <R> R get(String url, Class<R> responseType) {
        return this.client.get(url, responseType);
    }

    public <R> R get(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.get(url, params, responseType);
    }

    public <R> R get(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.get(url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> getCompletion(String url) {
        return this.asyncClient.get(url);
    }

    public HttpRequestCompletion<String> getCompletion(String url, Map<String, Serializable> params) {
        return this.asyncClient.get(url, params);
    }

    public HttpRequestCompletion<String> getCompletion(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.get(url, params, headers);
    }

    public <R> HttpRequestCompletion<R> getCompletion(String url, Class<R> responseType) {
        return this.asyncClient.get(url, responseType);
    }

    public <R> HttpRequestCompletion<R> getCompletion(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.get(url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> getCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.get(url, params, headers, responseType);
    }

    public Observable<String> getObservable(String url) {
        return this.rxjavaClient.get(url);
    }

    public Observable<String> getObservable(String url, Map<String, Serializable> params) {
        return this.rxjavaClient.get(url, params);
    }

    public Observable<String> getObservable(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.get(url, params, headers);
    }

    public <R> Observable<R> getObservable(String url, Class<R> responseType) {
        return this.rxjavaClient.get(url, responseType);
    }

    public <R> Observable<R> getObservable(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.get(url, params, responseType);
    }

    public <R> Observable<R> getObservable(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.get(url, params, headers, responseType);
    }

    public String head(String url) {
        return this.client.head(url);
    }

    public String head(String url, Map<String, Serializable> params) {
        return this.client.head(url, params);
    }

    public String head(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.head(url, params, headers);
    }

    public <R> R head(String url, Class<R> responseType) {
        return this.client.head(url, responseType);
    }

    public <R> R head(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.head(url, params, responseType);
    }

    public <R> R head(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.head(url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> headCompletion(String url) {
        return this.asyncClient.head(url);
    }

    public HttpRequestCompletion<String> headCompletion(String url, Map<String, Serializable> params) {
        return this.asyncClient.head(url, params);
    }

    public HttpRequestCompletion<String> headCompletion(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.head(url, params, headers);
    }

    public <R> HttpRequestCompletion<R> headCompletion(String url, Class<R> responseType) {
        return this.asyncClient.head(url, responseType);
    }

    public <R> HttpRequestCompletion<R> headCompletion(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.head(url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> headCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.head(url, params, headers, responseType);
    }

    public Observable<String> headObservable(String url) {
        return this.rxjavaClient.head(url);
    }

    public Observable<String> headObservable(String url, Map<String, Serializable> params) {
        return this.rxjavaClient.head(url, params);
    }

    public Observable<String> headObservable(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.head(url, params, headers);
    }

    public <R> Observable<R> headObservable(String url, Class<R> responseType) {
        return this.rxjavaClient.head(url, responseType);
    }

    public <R> Observable<R> headObservable(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.head(url, params, responseType);
    }

    public <R> Observable<R> headObservable(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.head(url, params, headers, responseType);
    }

    public String post(String url) {
        return this.client.post(url);
    }

    public String post(String url, Map<String, Serializable> params) {
        return this.client.post(url, params);
    }

    public String post(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.post(url, params, headers);
    }

    public <R> R post(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.post(url, params, responseType);
    }

    public <R> R post(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.post(url, params, headers, responseType);
    }

    public String post(String url, Object requestBody) {
        return this.client.post(url, requestBody);
    }

    public String post(String url, Object requestBody, Map<String, String> headers) {
        return this.client.post(url, requestBody, headers);
    }

    public <R> R post(String url, Object requestBody, Class<R> responseType) {
        return this.client.post(url, requestBody, responseType);
    }

    public <R> R post(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.client.post(url, requestBody, headers, responseType);
    }

    public HttpRequestCompletion<String> postCompletion(String url) {
        return this.asyncClient.post(url);
    }

    public HttpRequestCompletion<String> postCompletion(String url, Map<String, Serializable> params) {
        return this.asyncClient.post(url, params);
    }

    public HttpRequestCompletion<String> postCompletion(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.post(url, params, headers);
    }

    public <R> HttpRequestCompletion<R> postCompletion(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.post(url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> postCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.post(url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> postCompletion(String url, Object requestBody) {
        return this.asyncClient.post(url, requestBody);
    }

    public HttpRequestCompletion<String> postCompletion(String url, Object requestBody, Map<String, String> headers) {
        return this.asyncClient.post(url, requestBody, headers);
    }

    public <R> HttpRequestCompletion<R> postCompletion(String url, Object requestBody, Class<R> responseType) {
        return this.asyncClient.post(url, requestBody, responseType);
    }

    public <R> HttpRequestCompletion<R> postCompletion(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.post(url, requestBody, headers, responseType);
    }

    public Observable<String> postObservable(String url) {
        return this.rxjavaClient.post(url);
    }

    public Observable<String> postObservable(String url, Map<String, Serializable> params) {
        return this.rxjavaClient.post(url, params);
    }

    public Observable<String> postObservable(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.post(url, params, headers);
    }

    public <R> Observable<R> postObservable(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.post(url, params, responseType);
    }

    public <R> Observable<R> postObservable(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.post(url, params, headers, responseType);
    }

    public Observable<String> postObservable(String url, Object requestBody) {
        return this.rxjavaClient.post(url, requestBody);
    }

    public Observable<String> postObservable(String url, Object requestBody, Map<String, String> headers) {
        return this.rxjavaClient.post(url, requestBody, headers);
    }

    public <R> Observable<R> postObservable(String url, Object requestBody, Class<R> responseType) {
        return this.rxjavaClient.post(url, requestBody, responseType);
    }

    public <R> Observable<R> postObservable(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.post(url, requestBody, headers, responseType);
    }

    public String put(String url) {
        return this.client.put(url);
    }

    public String put(String url, Map<String, Serializable> params) {
        return this.client.put(url, params);
    }

    public String put(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.put(url, params, headers);
    }

    public <R> R put(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.put(url, params, responseType);
    }

    public <R> R put(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.put(url, params, headers, responseType);
    }

    public String put(String url, Object requestBody) {
        return this.client.put(url, requestBody);
    }

    public String put(String url, Object requestBody, Map<String, String> headers) {
        return this.client.put(url, requestBody, headers);
    }

    public <R> R put(String url, Object requestBody, Class<R> responseType) {
        return this.client.put(url, requestBody, responseType);
    }

    public <R> R put(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.client.put(url, requestBody, headers, responseType);
    }

    public HttpRequestCompletion<String> putCompletion(String url) {
        return this.asyncClient.put(url);
    }

    public HttpRequestCompletion<String> putCompletion(String url, Map<String, Serializable> params) {
        return this.asyncClient.put(url, params);
    }

    public HttpRequestCompletion<String> putCompletion(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.put(url, params, headers);
    }

    public <R> HttpRequestCompletion<R> putCompletion(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.put(url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> putCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.put(url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> putCompletion(String url, Object requestBody) {
        return this.asyncClient.put(url, requestBody);
    }

    public HttpRequestCompletion<String> putCompletion(String url, Object requestBody, Map<String, String> headers) {
        return this.asyncClient.put(url, requestBody, headers);
    }

    public <R> HttpRequestCompletion<R> putCompletion(String url, Object requestBody, Class<R> responseType) {
        return this.asyncClient.put(url, requestBody, responseType);
    }

    public <R> HttpRequestCompletion<R> putCompletion(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.put(url, requestBody, headers, responseType);
    }

    public Observable<String> putObservable(String url) {
        return this.rxjavaClient.put(url);
    }

    public Observable<String> putObservable(String url, Map<String, Serializable> params) {
        return this.rxjavaClient.put(url, params);
    }

    public Observable<String> putObservable(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.put(url, params, headers);
    }

    public <R> Observable<R> putObservable(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.put(url, params, responseType);
    }

    public <R> Observable<R> putObservable(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.put(url, params, headers, responseType);
    }

    public Observable<String> putObservable(String url, Object requestBody) {
        return this.rxjavaClient.put(url, requestBody);
    }

    public Observable<String> putObservable(String url, Object requestBody, Map<String, String> headers) {
        return this.rxjavaClient.put(url, requestBody, headers);
    }

    public <R> Observable<R> putObservable(String url, Object requestBody, Class<R> responseType) {
        return this.rxjavaClient.put(url, requestBody, responseType);
    }

    public <R> Observable<R> putObservable(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.put(url, requestBody, headers, responseType);
    }

    public String patch(String url) {
        return this.client.patch(url);
    }

    public String patch(String url, Map<String, Serializable> params) {
        return this.client.patch(url, params);
    }

    public String patch(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.client.patch(url, params, headers);
    }

    public <R> R patch(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.client.patch(url, params, responseType);
    }

    public <R> R patch(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.client.patch(url, params, headers, responseType);
    }

    public String patch(String url, Object requestBody) {
        return this.client.patch(url, requestBody);
    }

    public String patch(String url, Object requestBody, Map<String, String> headers) {
        return this.client.patch(url, requestBody, headers);
    }

    public <R> R patch(String url, Object requestBody, Class<R> responseType) {
        return this.client.patch(url, requestBody, responseType);
    }

    public <R> R patch(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.client.patch(url, requestBody, headers, responseType);
    }

    public HttpRequestCompletion<String> patchCompletion(String url) {
        return this.asyncClient.patch(url);
    }

    public HttpRequestCompletion<String> patchCompletion(String url, Map<String, Serializable> params) {
        return this.asyncClient.patch(url, params);
    }

    public HttpRequestCompletion<String> patchCompletion(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.asyncClient.patch(url, params, headers);
    }

    public <R> HttpRequestCompletion<R> patchCompletion(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.asyncClient.patch(url, params, responseType);
    }

    public <R> HttpRequestCompletion<R> patchCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.patch(url, params, headers, responseType);
    }

    public HttpRequestCompletion<String> patchCompletion(String url, Object requestBody) {
        return this.asyncClient.patch(url, requestBody);
    }

    public HttpRequestCompletion<String> patchCompletion(String url, Object requestBody, Map<String, String> headers) {
        return this.asyncClient.patch(url, requestBody, headers);
    }

    public <R> HttpRequestCompletion<R> patchCompletion(String url, Object requestBody, Class<R> responseType) {
        return this.asyncClient.patch(url, requestBody, responseType);
    }

    public <R> HttpRequestCompletion<R> patchCompletion(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.patch(url, requestBody, headers, responseType);
    }

    public Observable<String> patchObservable(String url) {
        return this.rxjavaClient.patch(url);
    }

    public Observable<String> patchObservable(String url, Map<String, Serializable> params) {
        return this.rxjavaClient.patch(url, params);
    }

    public Observable<String> patchObservable(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.rxjavaClient.patch(url, params, headers);
    }

    public <R> Observable<R> patchObservable(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.rxjavaClient.patch(url, params, responseType);
    }

    public <R> Observable<R> patchObservable(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.patch(url, params, headers, responseType);
    }

    public Observable<String> patchObservable(String url, Object requestBody) {
        return this.rxjavaClient.patch(url, requestBody);
    }

    public Observable<String> patchObservable(String url, Object requestBody, Map<String, String> headers) {
        return this.rxjavaClient.patch(url, requestBody, headers);
    }

    public <R> Observable<R> patchObservable(String url, Object requestBody, Class<R> responseType) {
        return this.rxjavaClient.patch(url, requestBody, responseType);
    }

    public <R> Observable<R> patchObservable(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.patch(url, requestBody, headers, responseType);
    }

    public String delete(String url) {
        return this.client.delete(url);
    }

    public String delete(String url, Map<String, String> headers) {
        return this.client.delete(url, headers);
    }

    public <R> R delete(String url, Class<R> responseType) {
        return this.client.delete(url, responseType);
    }

    public <R> R delete(String url, Map<String, String> headers, Class<R> responseType) {
        return this.client.delete(url, headers, responseType);
    }

    public String delete(String url, Object requestBody) {
        return this.client.delete(url, requestBody);
    }

    public String delete(String url, Object requestBody, Map<String, String> headers) {
        return this.client.delete(url, requestBody, headers);
    }

    public <R> R delete(String url, Object requestBody, Class<R> responseType) {
        return this.client.delete(url, requestBody, responseType);
    }

    public <R> R delete(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.client.delete(url, requestBody, headers, responseType);
    }

    public HttpRequestCompletion<String> deleteCompletion(String url) {
        return this.asyncClient.delete(url);
    }

    public HttpRequestCompletion<String> deleteCompletion(String url, Map<String, String> headers) {
        return this.asyncClient.delete(url, headers);
    }

    public <R> HttpRequestCompletion<R> deleteCompletion(String url, Class<R> responseType) {
        return this.asyncClient.delete(url, responseType);
    }

    public <R> HttpRequestCompletion<R> deleteCompletion(String url, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.delete(url, headers, responseType);
    }

    public HttpRequestCompletion<String> deleteCompletion(String url, Object requestBody) {
        return this.asyncClient.delete(url, requestBody);
    }

    public HttpRequestCompletion<String> deleteCompletion(String url, Object requestBody, Map<String, String> headers) {
        return this.asyncClient.delete(url, requestBody, headers);
    }

    public <R> HttpRequestCompletion<R> deleteCompletion(String url, Object requestBody, Class<R> responseType) {
        return this.asyncClient.delete(url, requestBody, responseType);
    }

    public <R> HttpRequestCompletion<R> deleteCompletion(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.asyncClient.delete(url, requestBody, headers, responseType);
    }

    public Observable<String> deleteObservable(String url) {
        return this.rxjavaClient.delete(url);
    }

    public Observable<String> deleteObservable(String url, Map<String, String> headers) {
        return this.rxjavaClient.delete(url, headers);
    }

    public <R> Observable<R> deleteObservable(String url, Class<R> responseType) {
        return this.rxjavaClient.delete(url, responseType);
    }

    public <R> Observable<R> deleteObservable(String url, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.delete(url, headers, responseType);
    }

    public Observable<String> deleteObservable(String url, Object requestBody) {
        return this.rxjavaClient.delete(url, requestBody);
    }

    public Observable<String> deleteObservable(String url, Object requestBody, Map<String, String> headers) {
        return this.rxjavaClient.delete(url, requestBody, headers);
    }

    public <R> Observable<R> deleteObservable(String url, Object requestBody, Class<R> responseType) {
        return this.rxjavaClient.delete(url, requestBody, responseType);
    }

    public <R> Observable<R> deleteObservable(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.rxjavaClient.delete(url, requestBody, headers, responseType);
    }

    public void download(String url, OutputStream output) {
        this.client.download(url, output);
    }

    public void download(String url, File localFile) {
        this.client.download(url, localFile);
    }

    public void download(String url, Map<String, Serializable> params, OutputStream output) {
        this.client.download(url, params, output);
    }

    public void download(String url, Map<String, Serializable> params, File localFile) {
        this.client.download(url, params, localFile);
    }

    public void download(String url, Map<String, Serializable> params, Map<String, String> headers, File localFile) {
        this.client.download(url, params, headers, localFile);
    }

    public void download(String url, Map<String, Serializable> params, Map<String, String> headers, OutputStream output) {
        this.client.download(url, params, headers, output);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, OutputStream output) {
        return this.asyncClient.download(url, output);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, File localFile) {
        return this.asyncClient.download(url, localFile);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, Map<String, Serializable> params, OutputStream output) {
        return this.asyncClient.download(url, params, output);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, Map<String, Serializable> params, File localFile) {
        return this.asyncClient.download(url, params, localFile);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, File localFile) {
        return this.asyncClient.download(url, params, headers, localFile);
    }

    public HttpRequestCompletion<Integer> downloadCompletion(String url, Map<String, Serializable> params, Map<String, String> headers, OutputStream output) {
        return this.asyncClient.download(url, params, headers, output);
    }

    public Observable<Integer> downloadObservable(String url, OutputStream output) {
        return this.rxjavaClient.download(url, output);
    }

    public Observable<Integer> downloadObservable(String url, File localFile) {
        return this.rxjavaClient.download(url, localFile);
    }

    public Observable<Integer> downloadObservable(String url, Map<String, Serializable> params, OutputStream output) {
        return this.rxjavaClient.download(url, params, output);
    }

    public Observable<Integer> downloadObservable(String url, Map<String, Serializable> params, File localFile) {
        return this.rxjavaClient.download(url, params, localFile);
    }

    public Observable<Integer> downloadObservable(String url, Map<String, Serializable> params, Map<String, String> headers, File localFile) {
        return this.rxjavaClient.download(url, params, headers, localFile);
    }

    public Observable<Integer> downloadObservable(String url, Map<String, Serializable> params, Map<String, String> headers, OutputStream output) {
        return this.rxjavaClient.download(url, params, headers, output);
    }
}

