/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.ErrorListener;
import cn.featherfly.common.http.HttpAsyncClient;
import cn.featherfly.common.http.HttpClient;
import cn.featherfly.common.http.HttpErrorResponse;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequest;
import cn.featherfly.common.http.HttpRequestCompletion;
import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpRxjavaClient;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.serialization.Serialization;
import io.reactivex.rxjava3.core.Observable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientRequest
implements HttpRequest {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpClient client;
    private HttpAsyncClient asyncClient;
    private HttpRxjavaClient rxjavaClient;

    public HttpClientRequest(HttpRequestConfig config) {
        this(config, Serialization.getDefault());
    }

    public HttpClientRequest(HttpRequestConfig config, Map<String, String> headers) {
        this(config, headers, Serialization.getDefault(), HttpUtils.JSON_MEDIA_TYPE);
    }

    public HttpClientRequest(HttpRequestConfig config, Serialization serialization) {
        this(config, serialization, HttpUtils.JSON_MEDIA_TYPE);
    }

    public HttpClientRequest(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        this(config, new HashMap<String, String>(), serialization, mediaType);
    }

    public HttpClientRequest(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this(new OkHttpClient.Builder().cache(new Cache(config.cacheDir, config.cacheMaxSize)).connectTimeout(config.connectTimeout, TimeUnit.SECONDS).build(), headers, serialization, mediaType);
    }

    public HttpClientRequest(OkHttpClient okHttpClient, Serialization serialization, MediaType mediaType) {
        this(okHttpClient, new HashMap<String, String>(), serialization, mediaType);
    }

    public HttpClientRequest(OkHttpClient okHttpClient, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this.client = new HttpClient(okHttpClient, headers, serialization, mediaType);
        this.asyncClient = new HttpAsyncClient(okHttpClient, headers, serialization, mediaType);
        this.rxjavaClient = new HttpRxjavaClient(okHttpClient, headers, serialization, mediaType);
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        String finalUrl = newUrl.toString();
        return this.asyncClient.request(method, finalUrl, requestBody, headers, responseType);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, requestBody, headers, responseType, errorListener, -1L);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener, long requestTimeoutSeconds) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        String finalUrl = newUrl.toString();
        try {
            return this.client.request(method, finalUrl, requestBody, headers, responseType);
        }
        catch (Exception e) {
            errorListener.error(new HttpErrorResponse(e.getMessage()));
            return null;
        }
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        String finalUrl = newUrl.toString();
        return this.asyncClient.request(method, finalUrl, params, headers, responseType);
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        String finalUrl = newUrl.toString();
        try {
            return this.client.request(method, finalUrl, params, headers, responseType);
        }
        catch (Exception e) {
            errorListener.error(new HttpErrorResponse(e.getMessage()));
            return null;
        }
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendCompletion(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, requestBody, new HashMap<String, String>(), responseType, errorListener);
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendCompletion(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendObservable(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        String finalUrl = newUrl.toString();
        return this.rxjavaClient.request(method, finalUrl, requestBody, headers, responseType);
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType) {
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        String finalUrl = newUrl.toString();
        return this.rxjavaClient.request(method, finalUrl, params, headers, responseType);
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendObservable(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType, errorListener);
    }

    protected <T> void preSend(HttpMethod method, StringBuilder url, Object params, Map<String, String> headers, Class<T> responseType) {
    }

    public void shutdown() {
        this.client.shutdown();
    }

    public HttpClient getHttpClient() {
        return this.client;
    }
}

