/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.AbstractHttpClient;
import cn.featherfly.common.http.HttpException;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.serialization.Serialization;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpRxjavaClient
extends AbstractHttpClient {
    private boolean autoSubscribeOnIo = true;

    public HttpRxjavaClient() {
    }

    public HttpRxjavaClient(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(config, headers, serialization, mediaType);
    }

    public HttpRxjavaClient(HttpRequestConfig config, Map<String, String> headers) {
        super(config, headers);
    }

    public HttpRxjavaClient(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        super(config, serialization, mediaType);
    }

    public HttpRxjavaClient(HttpRequestConfig config) {
        super(config);
    }

    public HttpRxjavaClient(Map<String, String> headers) {
        super(headers);
    }

    public HttpRxjavaClient(OkHttpClient client, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(client, headers, serialization, mediaType);
    }

    public HttpRxjavaClient(OkHttpClient client, Map<String, String> headers) {
        super(client, headers);
    }

    public HttpRxjavaClient(OkHttpClient client, Serialization serialization, MediaType mediaType) {
        super(client, serialization, mediaType);
    }

    public boolean isAutoSubscribeOnIo() {
        return this.autoSubscribeOnIo;
    }

    public void setAutoSubscribeOnIo(boolean autoSubscribeOnIo) {
        this.autoSubscribeOnIo = autoSubscribeOnIo;
    }

    public Observable<String> request(HttpMethod httpMethod, String url) {
        return this.request(httpMethod, url, new HashMap<String, Serializable>());
    }

    public Observable<String> request(HttpMethod httpMethod, String url, Map<String, Serializable> params) {
        return this.request(httpMethod, url, params, (Map<String, String>)EMPTY);
    }

    public Observable<String> request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers) {
        switch (httpMethod) {
            case GET: {
                return this.get(url, params, headers);
            }
            case POST: {
                return this.post(url, params, headers);
            }
            case PUT: {
                return this.put(url, params, headers);
            }
            case DELETE: {
                return this.delete(url, headers);
            }
            case HEAD: {
                return this.head(url, params, headers);
            }
            case PATCH: {
                return this.patch(url, params, headers);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public <R> Observable<R> request(HttpMethod httpMethod, String url, Class<R> responseType) {
        return this.request(httpMethod, url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> Observable<R> request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.request(httpMethod, url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        switch (httpMethod) {
            case GET: {
                return this.get(url, params, headers, responseType);
            }
            case POST: {
                return this.post(url, params, headers, responseType);
            }
            case PUT: {
                return this.put(url, params, headers, responseType);
            }
            case DELETE: {
                return this.delete(url, headers, responseType);
            }
            case HEAD: {
                return this.head(url, params, headers, responseType);
            }
            case PATCH: {
                return this.patch(url, params, headers, responseType);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public Observable<String> request(HttpMethod httpMethod, String url, Object requestBody) {
        return this.request(httpMethod, url, requestBody, (Map<String, String>)EMPTY);
    }

    public Observable<String> request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers) {
        switch (httpMethod) {
            case GET: {
                throw new HttpException("http get method can not send request body");
            }
            case POST: {
                return this.post(url, requestBody, headers);
            }
            case PUT: {
                return this.put(url, requestBody, headers);
            }
            case DELETE: {
                return this.delete(url, requestBody, headers);
            }
            case HEAD: {
                throw new HttpException("http head method can not send request body");
            }
            case PATCH: {
                return this.patch(url, requestBody, headers);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public <R> Observable<R> request(HttpMethod httpMethod, String url, Object requestBody, Class<R> responseType) {
        return this.request(httpMethod, url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        switch (httpMethod) {
            case GET: {
                throw new HttpException("http get method can not send request body");
            }
            case POST: {
                return this.post(url, requestBody, headers, responseType);
            }
            case PUT: {
                return this.put(url, requestBody, headers, responseType);
            }
            case DELETE: {
                return this.delete(url, requestBody, headers, responseType);
            }
            case HEAD: {
                throw new HttpException("http head method can not send request body");
            }
            case PATCH: {
                return this.patch(url, requestBody, headers, responseType);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public Observable<String> get(String url) {
        return this.get(url, new HashMap<String, Serializable>());
    }

    public Observable<String> get(String url, Map<String, Serializable> params) {
        return this.get(url, params, EMPTY);
    }

    public Observable<String> get(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build());
    }

    public <R> Observable<R> get(String url, Class<R> responseType) {
        return this.get(url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> Observable<R> get(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.get(url, params, EMPTY, responseType);
    }

    public <R> Observable<R> get(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build(), responseType);
    }

    public Observable<String> head(String url) {
        return this.head(url, new HashMap<String, Serializable>());
    }

    public Observable<String> head(String url, Map<String, Serializable> params) {
        return this.head(url, params, EMPTY);
    }

    public Observable<String> head(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).head().build());
    }

    public <R> Observable<R> head(String url, Class<R> responseType) {
        return this.head(url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> Observable<R> head(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.head(url, params, EMPTY, responseType);
    }

    public <R> Observable<R> head(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).head().build(), responseType);
    }

    public Observable<String> post(String url) {
        return this.post(url, new HashMap<String, Serializable>());
    }

    public Observable<String> post(String url, Map<String, Serializable> params) {
        return this.post(url, params, (Map<String, String>)EMPTY);
    }

    public Observable<String> post(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).post((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> Observable<R> post(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.post(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> post(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).post((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public Observable<String> post(String url, Object requestBody) {
        return this.post(url, requestBody, (Map<String, String>)EMPTY);
    }

    public Observable<String> post(String url, Object requestBody, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).post(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> Observable<R> post(String url, Object requestBody, Class<R> responseType) {
        return this.post(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> post(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).post(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public Observable<String> put(String url) {
        return this.put(url, new HashMap<String, Serializable>());
    }

    public Observable<String> put(String url, Map<String, Serializable> params) {
        return this.put(url, params, (Map<String, String>)EMPTY);
    }

    public Observable<String> put(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).put((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> Observable<R> put(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.put(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> put(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).put((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public Observable<String> put(String url, Object requestBody) {
        return this.put(url, requestBody, (Map<String, String>)EMPTY);
    }

    public Observable<String> put(String url, Object requestBody, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).put(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> Observable<R> put(String url, Object requestBody, Class<R> responseType) {
        return this.put(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> put(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).put(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public Observable<String> patch(String url) {
        return this.patch(url, new HashMap<String, Serializable>());
    }

    public Observable<String> patch(String url, Map<String, Serializable> params) {
        return this.patch(url, params, (Map<String, String>)EMPTY);
    }

    public Observable<String> patch(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> Observable<R> patch(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.patch(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> patch(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public Observable<String> patch(String url, Object requestBody) {
        return this.patch(url, requestBody, (Map<String, String>)EMPTY);
    }

    public Observable<String> patch(String url, Object requestBody, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> Observable<R> patch(String url, Object requestBody, Class<R> responseType) {
        return this.patch(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> Observable<R> patch(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public Observable<String> delete(String url) {
        return this.delete(url, EMPTY);
    }

    public Observable<String> delete(String url, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete().build());
    }

    public <R> Observable<R> delete(String url, Class<R> responseType) {
        return this.delete(url, EMPTY, responseType);
    }

    public <R> Observable<R> delete(String url, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete().build(), responseType);
    }

    public Observable<String> delete(String url, Object requestBody) {
        return this.delete(url, requestBody, EMPTY);
    }

    public Observable<String> delete(String url, Object requestBody, Map<String, String> headers) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> Observable<R> delete(String url, Object requestBody, Class<R> responseType) {
        return this.delete(url, requestBody, EMPTY, responseType);
    }

    public <R> Observable<R> delete(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.observation(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public Observable<Integer> download(String url, OutputStream output) {
        return this.download(url, new HashMap<String, Serializable>(), output);
    }

    public Observable<Integer> download(String url, File localFile) {
        return this.download(url, new HashMap<String, Serializable>(), localFile);
    }

    public Observable<Integer> download(String url, Map<String, Serializable> params, OutputStream output) {
        return this.download(url, params, (Map<String, String>)EMPTY, output);
    }

    public Observable<Integer> download(String url, Map<String, Serializable> params, File localFile) {
        return this.download(url, params, (Map<String, String>)EMPTY, localFile);
    }

    public Observable<Integer> download(String url, Map<String, Serializable> params, Map<String, String> headers, File localFile) {
        AssertIllegalArgument.isNotNull((Object)localFile, (String)"localFile");
        FileUtils.makeDirectory((File)localFile);
        try {
            return this.download(url, params, headers, new FileOutputStream(localFile));
        }
        catch (FileNotFoundException e) {
            throw new HttpException(e);
        }
    }

    public Observable<Integer> download(String url, Map<String, Serializable> params, Map<String, String> headers, final OutputStream output) {
        final Request request = new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build();
        Observable observable = Observable.create(emitter -> this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HttpRxjavaClient.this.logger.error("error at url: {}", (Object)request.url());
                emitter.onError((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    byte[] bs = response.body().bytes();
                    output.write(bs);
                    emitter.onNext((Object)bs.length);
                } else {
                    emitter.onError((Throwable)((Object)new HttpException(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{request.url(), response.code(), response.message()}))));
                }
            }
        }));
        if (this.autoSubscribeOnIo) {
            return observable.subscribeOn(Schedulers.io());
        }
        return observable;
    }

    private Observable<String> observation(final Request request) {
        Observable observable = Observable.create(emitter -> this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HttpRxjavaClient.this.logger.error("error at url: {}", (Object)request.url());
                emitter.onError((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200 || HttpRxjavaClient.this.isCodeSameAsSuccess(response)) {
                    emitter.onNext((Object)response.body().string());
                } else {
                    emitter.onError((Throwable)((Object)new HttpException(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{request.url(), response.code(), response.message()}))));
                }
            }
        }));
        if (this.autoSubscribeOnIo) {
            return observable.subscribeOn(Schedulers.io());
        }
        return observable;
    }

    private <R> Observable<R> observation(final Request request, final Class<R> responseType) {
        Observable observable = Observable.create(emitter -> this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                HttpRxjavaClient.this.logger.error("error at url: {}", (Object)request.url());
                emitter.onError((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200 || HttpRxjavaClient.this.isCodeSameAsSuccess(response)) {
                    emitter.onNext(HttpRxjavaClient.this.deserialize(response, responseType));
                } else {
                    emitter.onError((Throwable)((Object)new HttpException(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{request.url(), response.code(), response.message()}))));
                }
            }
        }));
        if (this.autoSubscribeOnIo) {
            return observable.subscribeOn(Schedulers.io());
        }
        return observable;
    }
}

