/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.AbstractHttpClient;
import cn.featherfly.common.http.HttpException;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.serialization.Serialization;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient
extends AbstractHttpClient {
    public HttpClient() {
    }

    public HttpClient(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(config, headers, serialization, mediaType);
    }

    public HttpClient(HttpRequestConfig config, Map<String, String> headers) {
        super(config, headers);
    }

    public HttpClient(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        super(config, serialization, mediaType);
    }

    public HttpClient(HttpRequestConfig config) {
        super(config);
    }

    public HttpClient(Map<String, String> headers) {
        super(headers);
    }

    public HttpClient(OkHttpClient client, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        super(client, headers, serialization, mediaType);
    }

    public HttpClient(OkHttpClient client, Map<String, String> headers) {
        super(client, headers);
    }

    public HttpClient(OkHttpClient client, Serialization serialization, MediaType mediaType) {
        super(client, serialization, mediaType);
    }

    public String request(HttpMethod httpMethod, String url) {
        return this.request(httpMethod, url, new HashMap<String, Serializable>());
    }

    public String request(HttpMethod httpMethod, String url, Map<String, Serializable> params) {
        return this.request(httpMethod, url, params, (Map<String, String>)EMPTY);
    }

    public String request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers) {
        switch (httpMethod) {
            case GET: {
                return this.get(url, params, headers);
            }
            case POST: {
                return this.post(url, params, headers);
            }
            case PUT: {
                return this.put(url, params, headers);
            }
            case DELETE: {
                return this.delete(url, headers);
            }
            case HEAD: {
                return this.head(url, params, headers);
            }
            case PATCH: {
                return this.patch(url, params, headers);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public <R> R request(HttpMethod httpMethod, String url, Class<R> responseType) {
        return this.request(httpMethod, url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.request(httpMethod, url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        switch (httpMethod) {
            case GET: {
                return this.get(url, params, headers, responseType);
            }
            case POST: {
                return this.post(url, params, headers, responseType);
            }
            case PUT: {
                return this.put(url, params, headers, responseType);
            }
            case DELETE: {
                return this.delete(url, headers, responseType);
            }
            case HEAD: {
                return this.head(url, params, headers, responseType);
            }
            case PATCH: {
                return this.patch(url, params, headers, responseType);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public String request(HttpMethod httpMethod, String url, Object requestBody) {
        return this.request(httpMethod, url, requestBody, (Map<String, String>)EMPTY);
    }

    public String request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers) {
        switch (httpMethod) {
            case GET: {
                throw new HttpException("http get method can not send request body");
            }
            case POST: {
                return this.post(url, requestBody, headers);
            }
            case PUT: {
                return this.put(url, requestBody, headers);
            }
            case DELETE: {
                return this.delete(url, requestBody, headers);
            }
            case HEAD: {
                throw new HttpException("http head method can not send request body");
            }
            case PATCH: {
                return this.patch(url, requestBody, headers);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public <R> R request(HttpMethod httpMethod, String url, Object requestBody, Class<R> responseType) {
        return this.request(httpMethod, url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R request(HttpMethod httpMethod, String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        switch (httpMethod) {
            case GET: {
                throw new HttpException("http get method can not send request body");
            }
            case POST: {
                return this.post(url, requestBody, headers, responseType);
            }
            case PUT: {
                return this.put(url, requestBody, headers, responseType);
            }
            case DELETE: {
                return this.delete(url, requestBody, headers, responseType);
            }
            case HEAD: {
                throw new HttpException("http head method can not send request body");
            }
            case PATCH: {
                return this.patch(url, requestBody, headers, responseType);
            }
        }
        throw new HttpException("unsupport http method " + httpMethod.toString());
    }

    public String get(String url) {
        return this.get(url, new HashMap<String, Serializable>());
    }

    public String get(String url, Map<String, Serializable> params) {
        return this.get(url, params, EMPTY);
    }

    public String get(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.request(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build());
    }

    public <R> R get(String url, Class<R> responseType) {
        return this.get(url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> R get(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.get(url, params, EMPTY, responseType);
    }

    public <R> R get(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build(), responseType);
    }

    public String head(String url) {
        return this.head(url, new HashMap<String, Serializable>());
    }

    public String head(String url, Map<String, Serializable> params) {
        return this.head(url, params, EMPTY);
    }

    public String head(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.request(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).head().build());
    }

    public <R> R head(String url, Class<R> responseType) {
        return this.head(url, new HashMap<String, Serializable>(), responseType);
    }

    public <R> R head(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.head(url, params, EMPTY, responseType);
    }

    public <R> R head(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).head().build(), responseType);
    }

    public String post(String url) {
        return this.post(url, new HashMap<String, Serializable>());
    }

    public String post(String url, Map<String, Serializable> params) {
        return this.post(url, params, (Map<String, String>)EMPTY);
    }

    public String post(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).post((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> R post(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.post(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R post(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).post((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public String post(String url, Object requestBody) {
        return this.post(url, requestBody, (Map<String, String>)EMPTY);
    }

    public String post(String url, Object requestBody, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).post(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> R post(String url, Object requestBody, Class<R> responseType) {
        return this.post(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R post(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).post(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public String put(String url) {
        return this.put(url, new HashMap<String, Serializable>());
    }

    public String put(String url, Map<String, Serializable> params) {
        return this.put(url, params, (Map<String, String>)EMPTY);
    }

    public String put(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).put((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> R put(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.put(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R put(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).put((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public String put(String url, Object requestBody) {
        return this.put(url, requestBody, (Map<String, String>)EMPTY);
    }

    public String put(String url, Object requestBody, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).put(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> R put(String url, Object requestBody, Class<R> responseType) {
        return this.put(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R put(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).put(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public String patch(String url) {
        return this.patch(url, new HashMap<String, Serializable>());
    }

    public String patch(String url, Map<String, Serializable> params) {
        return this.patch(url, params, (Map<String, String>)EMPTY);
    }

    public String patch(String url, Map<String, Serializable> params, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch((RequestBody)HttpUtils.createFormBody(params)).build());
    }

    public <R> R patch(String url, Map<String, Serializable> params, Class<R> responseType) {
        return this.patch(url, params, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R patch(String url, Map<String, Serializable> params, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch((RequestBody)HttpUtils.createFormBody(params)).build(), responseType);
    }

    public String patch(String url, Object requestBody) {
        return this.patch(url, requestBody, (Map<String, String>)EMPTY);
    }

    public String patch(String url, Object requestBody, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> R patch(String url, Object requestBody, Class<R> responseType) {
        return this.patch(url, requestBody, (Map<String, String>)EMPTY, responseType);
    }

    public <R> R patch(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).patch(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public String delete(String url) {
        return this.delete(url, EMPTY);
    }

    public String delete(String url, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete().build());
    }

    public <R> R delete(String url, Class<R> responseType) {
        return this.delete(url, EMPTY, responseType);
    }

    public <R> R delete(String url, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete().build(), responseType);
    }

    public String delete(String url, Object requestBody) {
        return this.delete(url, requestBody, EMPTY);
    }

    public String delete(String url, Object requestBody, Map<String, String> headers) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build());
    }

    public <R> R delete(String url, Object requestBody, Class<R> responseType) {
        return this.delete(url, requestBody, EMPTY, responseType);
    }

    public <R> R delete(String url, Object requestBody, Map<String, String> headers, Class<R> responseType) {
        return this.request(new Request.Builder().url(url).headers(this.createHeaders(headers)).delete(RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody))).build(), responseType);
    }

    public void download(String url, OutputStream output) {
        this.download(url, new HashMap<String, Serializable>(), output);
    }

    public void download(String url, File localFile) {
        this.download(url, new HashMap<String, Serializable>(), localFile);
    }

    public void download(String url, Map<String, Serializable> params, OutputStream output) {
        this.download(url, params, (Map<String, String>)EMPTY, output);
    }

    public void download(String url, Map<String, Serializable> params, File localFile) {
        this.download(url, params, (Map<String, String>)EMPTY, localFile);
    }

    public void download(String url, Map<String, Serializable> params, Map<String, String> headers, File localFile) {
        AssertIllegalArgument.isNotNull((Object)localFile, (String)"localFile");
        FileUtils.makeDirectory((File)localFile);
        try {
            this.download(url, params, headers, new FileOutputStream(localFile));
        }
        catch (FileNotFoundException e) {
            throw new HttpException(e);
        }
    }

    public void download(String url, Map<String, Serializable> params, Map<String, String> headers, OutputStream output) {
        Request request = new Request.Builder().url(HttpUtils.appendParams(url, params)).headers(this.createHeaders(headers)).get().build();
        try {
            Response response = this.client.newCall(request).execute();
            output.write(response.body().bytes());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    private String request(Request request) {
        try {
            return this.client.newCall(request).execute().body().string();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    private <R> R request(Request request, Class<R> responseType) {
        try {
            return this.deserialize(this.client.newCall(request).execute(), responseType);
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }
}

