/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.serialization.Serialization;
import cn.featherfly.common.serialization.SerializationException;
import cn.featherfly.common.serialization.SerializationExceptionCode;
import cn.featherfly.common.serialization.Serializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import okhttp3.Cache;
import okhttp3.Dispatcher;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClient {
    protected static final Map<String, String> EMPTY = new HashMap<String, String>();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected OkHttpClient client;
    protected boolean deserializeWithContentType;
    protected Serialization serialization;
    protected Serializer serializer;
    protected MediaType mediaType;
    protected Headers headers;
    protected Map<String, String> headersMap = new HashMap<String, String>();
    private Set<Integer> codeSameAsSuccess = new HashSet<Integer>();

    public AbstractHttpClient() {
        this(new HashMap<String, String>());
    }

    public AbstractHttpClient(HttpRequestConfig config) {
        this(config, null);
    }

    public AbstractHttpClient(Map<String, String> headers) {
        this(new HttpRequestConfig(), headers);
    }

    public AbstractHttpClient(HttpRequestConfig config, Map<String, String> headers) {
        this(config, null, null);
    }

    public AbstractHttpClient(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        this(config, null, serialization, mediaType);
    }

    public AbstractHttpClient(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this.init(this.client, headers, serialization, mediaType);
    }

    public AbstractHttpClient(OkHttpClient client, Map<String, String> headers) {
        this(client, null, null);
    }

    public AbstractHttpClient(OkHttpClient client, Serialization serialization, MediaType mediaType) {
        this(client, null, serialization, mediaType);
    }

    public AbstractHttpClient(OkHttpClient client, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this.init(client, headers, serialization, mediaType);
    }

    protected void init(HttpRequestConfig config, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this.init(this.okHttpClient(config), headers, serialization, mediaType);
    }

    private OkHttpClient okHttpClient(HttpRequestConfig config) {
        if (config == null) {
            config = new HttpRequestConfig();
        }
        Dispatcher dispatcher = new Dispatcher(config.executorService);
        dispatcher.setMaxRequests(config.maxRequests);
        dispatcher.setMaxRequestsPerHost(config.maxRequestsPerHost);
        return new OkHttpClient.Builder().cache(new Cache(config.cacheDir, config.cacheMaxSize)).dispatcher(dispatcher).connectTimeout(config.connectTimeout, TimeUnit.SECONDS).build();
    }

    protected void init(OkHttpClient client, Map<String, String> headers, Serialization serialization, MediaType mediaType) {
        this.client = client == null ? this.okHttpClient(null) : client;
        this.serialization = serialization == null ? Serialization.getDefault() : serialization;
        this.mediaType = mediaType == null ? HttpUtils.JSON_MEDIA_TYPE : mediaType;
        this.serializer = this.getSerializer(this.mediaType, true);
        if (headers != null) {
            this.headersMap.putAll(headers);
        }
        this.headers = HttpUtils.createHeaders(this.headersMap);
    }

    public void shutdown() {
        this.client.dispatcher().executorService().shutdown();
    }

    public boolean isDeserializeWithContentType() {
        return this.deserializeWithContentType;
    }

    public Set<Integer> getCodeSameAsSuccess() {
        return this.codeSameAsSuccess;
    }

    public void setCodeSameAsSuccess(Set<Integer> codeSameAsSuccess) {
        this.codeSameAsSuccess = codeSameAsSuccess;
    }

    public void setDeserializeWithContentType(boolean deserializeWithContentType) {
        this.deserializeWithContentType = deserializeWithContentType;
    }

    protected <T> T deserialize(Response response, Class<T> responseType) throws IOException {
        Serializer serializer = null;
        if (this.deserializeWithContentType) {
            MediaType mediaType = response.body().contentType();
            if (mediaType == null) {
                mediaType = HttpUtils.JSON_MEDIA_TYPE;
            }
            serializer = this.getSerializer(mediaType, false);
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        return (T)serializer.deserialize(response.body().bytes(), responseType);
    }

    protected Serializer getSerializer(MediaType mediaType, boolean throwExceptionNoSerializer) {
        Serializer serializer = null;
        try {
            MimeType mimeType = new MimeType(mediaType.type(), mediaType.subtype());
            serializer = this.serialization.getSerializer(mimeType);
            if (serializer == null && throwExceptionNoSerializer) {
                throw new SerializationException(SerializationExceptionCode.createNoSerializerForMimeTypeCode((String)mimeType.getBaseType()));
            }
            this.logger.warn("no serializer found for content-type {}", (Object)mimeType.getBaseType());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            // empty catch block
        }
        return serializer;
    }

    protected Headers createHeaders(Map<String, String> headers) {
        if (Lang.isEmpty(headers)) {
            return this.headers;
        }
        return HttpUtils.createHeaders(headers, this.headersMap);
    }

    protected boolean isCodeSameAsSuccess(Response response) {
        return this.codeSameAsSuccess.contains(response.code());
    }
}

