/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.ErrorListener;
import cn.featherfly.common.http.HttpErrorResponse;
import cn.featherfly.common.http.HttpException;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequest;
import cn.featherfly.common.http.HttpRequestCompletion;
import cn.featherfly.common.http.HttpRequestCompletionImpl;
import cn.featherfly.common.http.HttpRequestConfig;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.serialization.Serialization;
import cn.featherfly.common.serialization.SerializationException;
import cn.featherfly.common.serialization.SerializationExceptionCode;
import cn.featherfly.common.serialization.Serializer;
import io.reactivex.Observable;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpRequest
implements HttpRequest {
    private static final String JSON_STR = "application/json; charset=utf-8";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Serialization serialization;
    private OkHttpClient client;
    private Serializer serializer;
    private MediaType mediaType;
    private boolean deserializeWithContentType = true;

    public OkHttpRequest(HttpRequestConfig config) {
        this(config, Serialization.getDefault());
    }

    public OkHttpRequest(HttpRequestConfig config, Serialization serialization) {
        this(config, serialization, JSON);
    }

    public OkHttpRequest(HttpRequestConfig config, Serialization serialization, MediaType mediaType) {
        this(new OkHttpClient.Builder().cache(new Cache(config.cacheDir, config.cacheMaxSize)).connectTimeout(config.connectTimeout, TimeUnit.SECONDS).build(), serialization, mediaType);
    }

    public OkHttpRequest(OkHttpClient okHttpClient, Serialization serialization, MediaType mediaType) {
        this.client = okHttpClient;
        this.serialization = serialization == null ? Serialization.getDefault() : serialization;
        this.mediaType = mediaType == null ? JSON : mediaType;
        this.serializer = this.getSerializer(this.mediaType, true);
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Map<String, String> headers, final Class<T> responseType) {
        if (method != HttpMethod.POST && method != HttpMethod.PUT) {
            throw new IllegalArgumentException("send\u65b9\u6cd5\u8bf7\u6c42method\u53ea\u80fd\u662fPOST\u6216\u8005PUT");
        }
        final StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        final String finalUrl = newUrl.toString();
        RequestBody body = RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody));
        Request request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), body).build();
        final HttpRequestCompletionImpl hanlder = new HttpRequestCompletionImpl();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpRequest.this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + newUrl.toString());
                hanlder.setHttpErrorResponse(new HttpErrorResponse(e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    hanlder.setResponse(OkHttpRequest.this.deserialize(response, responseType));
                } else {
                    hanlder.setHttpErrorResponse(new HttpErrorResponse(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{finalUrl, response.code(), response.message()})));
                }
            }
        });
        return hanlder;
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, requestBody, headers, responseType, errorListener, -1L);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener, long requestTimeoutSeconds) {
        if (method != HttpMethod.POST && method != HttpMethod.PUT) {
            throw new IllegalArgumentException("send\u65b9\u6cd5\u8bf7\u6c42method\u53ea\u80fd\u662fPOST\u6216\u8005PUT");
        }
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        String finalUrl = newUrl.toString();
        RequestBody body = RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody));
        Request request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), body).build();
        try {
            return this.deserialize(this.client.newCall(request).execute(), responseType);
        }
        catch (IOException e) {
            this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + finalUrl);
            errorListener.error(new HttpErrorResponse(e.getMessage()));
            return null;
        }
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, final Class<T> responseType) {
        String finalUrl;
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        Request request = null;
        if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
            finalUrl = HttpUtils.appendParam(newUrl.toString(), params);
            request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), null).build();
        } else {
            finalUrl = newUrl.toString();
            request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), (RequestBody)HttpUtils.createFormBody(params)).build();
        }
        final HttpRequestCompletionImpl hanlder = new HttpRequestCompletionImpl();
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpRequest.this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + finalUrl);
                hanlder.setHttpErrorResponse(new HttpErrorResponse(e.getMessage()));
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    hanlder.setResponse(OkHttpRequest.this.deserialize(response, responseType));
                } else {
                    hanlder.setHttpErrorResponse(new HttpErrorResponse(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{finalUrl, response.code(), response.message()})));
                }
            }
        });
        return hanlder;
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        String finalUrl;
        StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        Request request = null;
        if (method == HttpMethod.GET || method == HttpMethod.HEAD) {
            finalUrl = HttpUtils.appendParam(newUrl.toString(), params);
            request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), null).build();
        } else {
            finalUrl = newUrl.toString();
            request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), (RequestBody)HttpUtils.createFormBody(params)).build();
        }
        try {
            return this.deserialize(this.client.newCall(request).execute(), responseType);
        }
        catch (IOException e) {
            this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + finalUrl);
            errorListener.error(new HttpErrorResponse(e.getMessage()));
            return null;
        }
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendCompletion(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, requestBody, new HashMap<String, String>(), responseType, errorListener);
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendCompletion(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendObservable(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Map<String, String> headers, final Class<T> responseType) {
        if (method != HttpMethod.POST && method != HttpMethod.PUT) {
            throw new IllegalArgumentException("send\u65b9\u6cd5\u8bf7\u6c42method\u53ea\u80fd\u662fPOST\u6216\u8005PUT");
        }
        final StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, requestBody, headers, responseType);
        final String finalUrl = newUrl.toString();
        RequestBody body = RequestBody.create((MediaType)this.mediaType, (byte[])this.serializer.serialize(requestBody));
        Request request = new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), body).build();
        return Observable.create(emitter -> this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpRequest.this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + newUrl.toString());
                emitter.onError((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    emitter.onNext(OkHttpRequest.this.deserialize(response, responseType));
                } else {
                    emitter.onError((Throwable)((Object)new HttpException(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{finalUrl, response.code(), response.message()}))));
                }
            }
        }));
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, final Class<T> responseType) {
        final StringBuilder newUrl = new StringBuilder(url);
        this.preSend(method, newUrl, params, headers, responseType);
        final String finalUrl = newUrl.toString();
        Request request = method == HttpMethod.GET || method == HttpMethod.HEAD ? new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), null).build() : new Request.Builder().url(finalUrl).method(method.toOkHttpCode(), (RequestBody)HttpUtils.createFormBody(params)).build();
        return Observable.create(emitter -> this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                OkHttpRequest.this.logger.error("\u7f51\u7edc\u9519\u8bef\u7684URL:" + newUrl.toString());
                emitter.onError((Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() == 200) {
                    emitter.onNext(OkHttpRequest.this.deserialize(response, responseType));
                } else {
                    emitter.onError((Throwable)((Object)new HttpException(Strings.format((String)"{0} error, code {1}, message {2}", (Object[])new Object[]{finalUrl, response.code(), response.message()}))));
                }
            }
        }));
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendObservable(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType, errorListener);
    }

    protected <T> void preSend(HttpMethod method, StringBuilder url, Object params, Map<String, String> headers, Class<T> responseType) {
    }

    private <T> T deserialize(Response response, Class<T> responseType) throws IOException {
        Serializer serializer = null;
        if (this.deserializeWithContentType) {
            serializer = this.getSerializer(MediaType.parse((String)response.header("Content-Type", JSON_STR)), false);
        }
        if (serializer == null) {
            serializer = this.serializer;
        }
        return (T)serializer.deserialize(response.body().bytes(), responseType);
    }

    private Serializer getSerializer(MediaType mediaType, boolean throwExceptionNoSerializer) {
        Serializer serializer = null;
        try {
            MimeType mimeType = new MimeType(mediaType.type(), mediaType.subtype());
            serializer = this.serialization.getSerializer(mimeType);
            if (serializer == null && throwExceptionNoSerializer) {
                throw new SerializationException(SerializationExceptionCode.createNoSerializerForMimeTypeCode((String)mimeType.getBaseType()));
            }
            this.logger.warn("no serializer found for content-type {}", (Object)mimeType.getBaseType());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            // empty catch block
        }
        return serializer;
    }

    public void shutdown() {
        this.client.dispatcher().executorService().shutdown();
    }

    public boolean isDeserializeWithContentType() {
        return this.deserializeWithContentType;
    }

    public void setDeserializeWithContentType(boolean deserializeWithContentType) {
        this.deserializeWithContentType = deserializeWithContentType;
    }
}

