/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.lang.Lang;
import java.io.Serializable;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.Response;

public class HttpUtils {
    public static final String DEFAULT_CONTENT_TYPE = "text/html; charset=utf-8";

    public static MediaType getContentType(Response response) {
        return MediaType.parse((String)response.header("Content-Type", DEFAULT_CONTENT_TYPE));
    }

    public static FormBody createFormBody(Map<String, Serializable> params) {
        FormBody.Builder formBodyBuilder = new FormBody.Builder();
        if (Lang.isNotEmpty(params)) {
            for (Map.Entry<String, Serializable> entry : params.entrySet()) {
                if (entry.getValue() == null) continue;
                formBodyBuilder.add(entry.getKey(), entry.getValue().toString());
            }
        }
        return formBodyBuilder.build();
    }

    public static String toParameString(Map<String, Serializable> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Serializable> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String appendParam(String url, Map<String, Serializable> params) {
        if (Lang.isEmpty(params)) {
            url = !url.contains("?") ? url + "?" : url + "&";
            url = url + HttpUtils.toParameString(params);
        }
        return url;
    }
}

