/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.HttpException;
import cn.featherfly.common.http.HttpUtils;
import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Http {
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().cache(new Cache(FileUtils.getTempDirectory(), 1024L)).connectTimeout(60L, TimeUnit.SECONDS).build();

    public static String get(String url) {
        return Http.get(url, new HashMap<String, Serializable>());
    }

    public static String get(String url, Map<String, Serializable> params) {
        Request request = new Request.Builder().url(HttpUtils.appendParam(url, params)).get().build();
        try {
            return CLIENT.newCall(request).execute().body().toString();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static String post(String url) {
        return Http.post(url, new HashMap<String, Serializable>());
    }

    public static String post(String url, Map<String, Serializable> params) {
        Request request = new Request.Builder().url(url).post((RequestBody)HttpUtils.createFormBody(params)).build();
        try {
            return CLIENT.newCall(request).execute().body().toString();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static String put(String url) {
        return Http.put(url, new HashMap<String, Serializable>());
    }

    public static String put(String url, Map<String, Serializable> params) {
        Request request = new Request.Builder().url(url).put((RequestBody)HttpUtils.createFormBody(params)).build();
        try {
            return CLIENT.newCall(request).execute().body().toString();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static String delete(String url) {
        Request request = new Request.Builder().url(url).delete().build();
        try {
            return CLIENT.newCall(request).execute().body().toString();
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static final void download(String url, OutputStream output) {
        Http.download(url, new HashMap<String, Serializable>(), output);
    }

    public static final void download(String url, File localFile) {
        Http.download(url, new HashMap<String, Serializable>(), localFile);
    }

    public static final void download(String url, Map<String, Serializable> params, OutputStream output) {
        Request request = new Request.Builder().url(HttpUtils.appendParam(url, params)).get().build();
        try {
            Response response = CLIENT.newCall(request).execute();
            output.write(response.body().bytes());
        }
        catch (IOException e) {
            throw new HttpException(e);
        }
    }

    public static final void download(String url, Map<String, Serializable> params, File localFile) {
        AssertIllegalArgument.isNotNull((Object)localFile, (String)"localFile");
        FileUtils.makeDirectory((File)localFile);
        try {
            Http.download(url, params, new FileOutputStream(localFile));
        }
        catch (FileNotFoundException e) {
            throw new HttpException(e);
        }
    }
}

