/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.http;

import cn.featherfly.common.http.ErrorListener;
import cn.featherfly.common.http.HttpMethod;
import cn.featherfly.common.http.HttpRequest;
import cn.featherfly.common.http.HttpRequestCompletion;
import io.reactivex.Observable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BrowerRequest
implements HttpRequest {
    private HttpRequest httpRequest;

    public BrowerRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendCompletion(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.sendCompletion(method, url, requestBody, headers, responseType);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, requestBody, new HashMap<String, String>(), responseType, errorListener);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.send(method, url, requestBody, headers, responseType, errorListener);
    }

    @Override
    public <R, T> T send(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener, long requestTimeoutSeconds) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.send(method, url, requestBody, headers, responseType, errorListener, requestTimeoutSeconds);
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.sendCompletion(method, url, params, headers, responseType);
    }

    @Override
    public <T> HttpRequestCompletion<T> sendCompletion(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendCompletion(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType, ErrorListener errorListener) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.send(method, url, params, headers, responseType, errorListener);
    }

    @Override
    public <T> T send(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType, ErrorListener errorListener) {
        return this.send(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType, errorListener);
    }

    private void addBrowerHeaders(Map<String, String> headers) {
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8");
        headers.put("Accept-Encoding", "gzip, deflate");
        headers.put("Accept-Language", "zh-CN,zh;q=0.9");
        headers.put("Upgrade-Insecure-Requests", "1");
        headers.put("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.81 Safari/537.36 SE 2.X MetaSr 1.0");
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Class<T> responseType) {
        return this.sendObservable(method, url, requestBody, new HashMap<String, String>(), responseType);
    }

    @Override
    public <R, T> Observable<T> sendObservable(HttpMethod method, String url, R requestBody, Map<String, String> headers, Class<T> responseType) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.sendObservable(method, url, requestBody, headers, responseType);
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Map<String, String> headers, Class<T> responseType) {
        this.addBrowerHeaders(headers);
        return this.httpRequest.sendObservable(method, url, params, headers, responseType);
    }

    @Override
    public <T> Observable<T> sendObservable(HttpMethod method, String url, Map<String, Serializable> params, Class<T> responseType) {
        return this.sendObservable(method, url, params, (Map<String, String>)new HashMap<String, String>(), responseType);
    }
}

