/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping.mappers;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.db.mapping.AbstractJavaSqlTypeMapper;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.reflect.GenericClass;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ObjectToJsonMapper<E>
extends AbstractJavaSqlTypeMapper<E> {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private ObjectMapper objectMapper;
    private boolean storeAsString = true;
    private JavaType javaType;

    public ObjectToJsonMapper(Class<E> type) {
        this(type, MAPPER);
    }

    public ObjectToJsonMapper(Class<E> type, ObjectMapper objectMapper) {
        this(type, objectMapper, true);
    }

    public ObjectToJsonMapper(Class<E> type, ObjectMapper objectMapper, boolean storeAsString) {
        this((GenericType<E>)new GenericClass(type), objectMapper, storeAsString);
    }

    public ObjectToJsonMapper(GenericType<E> type) {
        this(type, MAPPER);
    }

    public ObjectToJsonMapper(GenericType<E> type, ObjectMapper objectMapper) {
        this(type, objectMapper, true);
    }

    public ObjectToJsonMapper(GenericType<E> genericType, ObjectMapper objectMapper, boolean storeAsString) {
        this(genericType, objectMapper, null, storeAsString);
    }

    private ObjectToJsonMapper(GenericType<E> genericType, ObjectMapper objectMapper, JavaType javaType, boolean storeAsString) {
        super(genericType);
        this.objectMapper = objectMapper;
        this.storeAsString = storeAsString;
        this.javaType = javaType;
        if (this.javaType == null) {
            if (genericType.getType().isArray()) {
                this.javaType = objectMapper.getTypeFactory().constructArrayType(genericType.getType().getComponentType());
            } else if (genericType instanceof BeanProperty) {
                BeanProperty bp = (BeanProperty)genericType;
                if (ClassUtils.isParent(Collection.class, (Class)bp.getType())) {
                    this.javaType = objectMapper.getTypeFactory().constructCollectionType(bp.getType(), bp.getGenericType());
                } else if (ClassUtils.isParent(Map.class, (Class)bp.getType())) {
                    if (bp.getGenericTypes().size() != 2) {
                        throw new JdbcException(Strings.format((String)"bean property {0} type is Map and generic type size must be 2", (Object)bp.toString()));
                    }
                    List genericTypes = bp.getGenericTypes();
                    this.javaType = objectMapper.getTypeFactory().constructMapType(bp.getType(), (Class)genericTypes.get(0), (Class)genericTypes.get(1));
                }
            }
        }
        if (this.javaType == null) {
            this.javaType = objectMapper.getTypeFactory().constructType((Type)genericType.getType());
        }
    }

    @Override
    protected boolean support(SQLType sqlType) {
        if (this.storeAsString) {
            return sqlType == JDBCType.VARCHAR || sqlType == JDBCType.NVARCHAR || sqlType == JDBCType.LONGVARCHAR || sqlType == JDBCType.LONGNVARCHAR || sqlType == JDBCType.CLOB || sqlType == JDBCType.NCLOB || sqlType == JDBCType.JAVA_OBJECT;
        }
        return sqlType == JDBCType.BLOB;
    }

    @Override
    public void set(PreparedStatement prep, int columnIndex, E value) {
        try {
            if (value == null) {
                prep.setObject(columnIndex, null);
            }
            if (this.storeAsString) {
                String json = this.objectMapper.writerFor(this.javaType).writeValueAsString(value);
                prep.setString(columnIndex, json);
            } else {
                ByteArrayInputStream is = new ByteArrayInputStream(this.objectMapper.writerFor(this.getGenericType().getType()).writeValueAsBytes(value));
                prep.setBlob(columnIndex, is);
            }
        }
        catch (JsonProcessingException | SQLException e) {
            throw new JdbcException(e);
        }
    }

    @Override
    public E get(ResultSet rs, int columnIndex) {
        try {
            if (this.storeAsString) {
                String json = rs.getString(columnIndex);
                if (StringUtils.isBlank((CharSequence)json)) {
                    return null;
                }
                return (E)this.objectMapper.readerFor(this.javaType).readValue(json);
            }
            Blob blob = rs.getBlob(columnIndex);
            if (blob == null) {
                return null;
            }
            return (E)this.objectMapper.readerFor(this.getGenericType().getType()).readValue(blob.getBinaryStream());
        }
        catch (IOException | SQLException e) {
            throw new JdbcException(e);
        }
    }
}

