/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping.mappers;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.AbstractGenericJavaSqlTypeMapper;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.NumberUtils;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.List;

public class NumberListJavaSqlTypeMapper<N extends Number>
extends AbstractGenericJavaSqlTypeMapper<List<N>> {
    private Class<N> numberType;

    public NumberListJavaSqlTypeMapper(Class<N> numberType) {
        this.numberType = numberType;
    }

    @Override
    public boolean support(SQLType sqlType) {
        return JDBCType.VARCHAR == sqlType || JDBCType.NVARCHAR == sqlType || JDBCType.CHAR == sqlType || JDBCType.NCHAR == sqlType;
    }

    @Override
    public boolean support(GenericType<List<N>> type) {
        return this.getGenericType().getType().equals(type.getType());
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex, List<N> values) {
        if (values != null) {
            StringBuilder result = new StringBuilder();
            for (Number value : values) {
                result.append(value).append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            JdbcUtils.setParameter(prep, parameterIndex, (Object)result.toString());
        } else {
            JdbcUtils.setParameter(prep, parameterIndex, null);
        }
    }

    @Override
    public List<N> get(ResultSet rs, int columnIndex) {
        String value = (String)JdbcUtils.getResultSetValue(rs, columnIndex, String.class);
        if (value != null) {
            String[] values = value.split(",");
            ArrayList<Number> numbers = new ArrayList<Number>(values.length);
            for (String v : values) {
                numbers.add(NumberUtils.parse((String)v, this.numberType));
            }
            return numbers;
        }
        return null;
    }
}

