/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyAnnotationMatcher;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.common.db.Table;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.jpa.Comment;
import cn.featherfly.common.db.mapping.AbstractJdbcMappingFactory;
import cn.featherfly.common.db.mapping.JdbcMappingException;
import cn.featherfly.common.db.mapping.SqlTypeMappingManager;
import cn.featherfly.common.db.metadata.DatabaseMetadata;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.SystemPropertyUtils;
import cn.featherfly.common.repository.Index;
import cn.featherfly.common.repository.mapping.ClassMapping;
import cn.featherfly.common.repository.mapping.ClassNameConversion;
import cn.featherfly.common.repository.mapping.PropertyMapping;
import cn.featherfly.common.repository.mapping.PropertyNameConversion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;

public class ObjectToDbMappingFactory
extends AbstractJdbcMappingFactory {
    private boolean checkMapping = true;

    public ObjectToDbMappingFactory(DatabaseMetadata metadata, Dialect dialect) {
        super(metadata, dialect);
    }

    public ObjectToDbMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager) {
        super(metadata, dialect, sqlTypeMappingManager);
    }

    public ObjectToDbMappingFactory(DatabaseMetadata metadata, Dialect dialect, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        super(metadata, dialect, classNameConversions, propertyNameConversions);
    }

    public ObjectToDbMappingFactory(DatabaseMetadata metadata, Dialect dialect, SqlTypeMappingManager sqlTypeMappingManager, List<ClassNameConversion> classNameConversions, List<PropertyNameConversion> propertyNameConversions) {
        super(metadata, dialect, sqlTypeMappingManager, classNameConversions, propertyNameConversions);
    }

    public <T> ClassMapping<T> getClassMapping(Class<T> type) {
        ClassMapping<T> classMapping = (ClassMapping<T>)this.mappedTypes.get(type);
        if (classMapping == null) {
            classMapping = this.createClassMapping(type);
            this.mappedTypes.put(type, classMapping);
        }
        return classMapping;
    }

    private <T> List<Index> createIndexs(javax.persistence.Table table) {
        ArrayList<Index> indexs = new ArrayList<Index>();
        if (table != null) {
            for (javax.persistence.Index index : table.indexes()) {
                indexs.add(new Index(index.name(), index.columnList().split(","), index.unique()));
            }
            for (javax.persistence.Index index : table.uniqueConstraints()) {
                indexs.add(new Index(index.name(), index.columnNames(), true));
            }
        }
        return indexs;
    }

    private <T> ClassMapping<T> createClassMapping(Class<T> type) {
        javax.persistence.Table table;
        LinkedHashMap<String, PropertyMapping> tableMapping = new LinkedHashMap<String, PropertyMapping>();
        StringBuilder logInfo = new StringBuilder();
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(type);
        String tableName = this.getMappingTableName(type);
        tableName = this.dialect.convertTableOrColumnName(tableName);
        String remark = null;
        String schema = null;
        Comment comment = (Comment)bd.getAnnotation(Comment.class);
        if (comment != null) {
            remark = comment.value();
        }
        if ((table = (javax.persistence.Table)bd.getAnnotation(javax.persistence.Table.class)) != null) {
            schema = table.schema();
        }
        if (this.logger.isDebugEnabled()) {
            logInfo.append(String.format("###%s\u7c7b%s\u6620\u5c04\u5230\u8868%s", SystemPropertyUtils.getLineSeparator(), type.getName(), tableName));
        }
        Collection bps = bd.getBeanProperties();
        boolean findPk = false;
        int pkNo = 0;
        for (BeanProperty beanProperty : bps) {
            if (!this.mappingWithJpa(beanProperty, tableMapping, logInfo)) continue;
            findPk = true;
            ++pkNo;
        }
        if (!findPk) {
            throw new JdbcMappingException("#id.map.not.exists", new Object[]{type.getName()});
        }
        if (this.checkMapping) {
            Table tm = this.getMappingTable(tableName);
            this.checkMapping(bd, tableMapping, tm);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(logInfo.toString());
        }
        this.checkTableMapping(tableMapping);
        ClassMapping classMapping = new ClassMapping(type, tableName, schema, remark);
        classMapping.addIndexs(this.createIndexs(table));
        classMapping.addPropertyMappings((Collection)tableMapping.values().stream().sorted((p1, p2) -> p1.getIndex() < p2.getIndex() ? -1 : 1).collect(Collectors.toList()));
        if (pkNo > 1) {
            classMapping.getPropertyMappings().forEach(pm -> {
                if (pm.isPrimaryKey()) {
                    pm.setAutoincrement(false);
                }
            });
        }
        return classMapping;
    }

    private boolean mappingWithJpa(BeanProperty<?> beanProperty, Map<String, PropertyMapping> tableMapping, StringBuilder logInfo) {
        if (this.isTransient(beanProperty, logInfo)) {
            return false;
        }
        boolean isPk = beanProperty.hasAnnotation(Id.class);
        PropertyMapping mapping = new PropertyMapping();
        Embedded embedded = (Embedded)beanProperty.getAnnotation(Embedded.class);
        if (embedded != null) {
            this.mappinEmbedded(mapping, beanProperty, logInfo);
            tableMapping.put(mapping.getRepositoryFieldName(), mapping);
        } else {
            String columnName = this.getMappingColumnName(beanProperty);
            if (Lang.isNotEmpty((String)columnName)) {
                columnName = this.dialect.convertTableOrColumnName(columnName);
                mapping.setPropertyName(beanProperty.getName());
                mapping.setPropertyType(beanProperty.getType());
                mapping.setPrimaryKey(isPk);
                ManyToOne manyToOne = (ManyToOne)beanProperty.getAnnotation(ManyToOne.class);
                OneToOne oneToOne = (OneToOne)beanProperty.getAnnotation(OneToOne.class);
                if (manyToOne != null || oneToOne != null) {
                    mapping.setRepositoryFieldName(columnName);
                    this.mappingFk(mapping, beanProperty, columnName, isPk, logInfo);
                } else {
                    mapping.setRepositoryFieldName(columnName);
                    this.setColumnMapping(mapping, beanProperty);
                    mapping.setNullable(!isPk);
                }
                tableMapping.put(mapping.getRepositoryFieldName(), mapping);
                if (this.logger.isDebugEnabled()) {
                    logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName(), mapping.getRepositoryFieldName()));
                }
            }
        }
        return isPk;
    }

    private void mappinEmbedded(PropertyMapping mapping, BeanProperty<?> beanProperty, StringBuilder logInfo) {
        mapping.setPropertyName(beanProperty.getName());
        mapping.setPropertyType(beanProperty.getType());
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor((Class)beanProperty.getType());
        Collection bps = bd.getBeanProperties();
        for (BeanProperty bp : bps) {
            if (this.isTransient(bp, logInfo)) continue;
            String columnName = this.getMappingColumnName(bp);
            columnName = this.dialect.convertTableOrColumnName(columnName);
            PropertyMapping columnMpping = new PropertyMapping();
            columnMpping.setRepositoryFieldName(columnName);
            columnMpping.setPropertyType(bp.getType());
            columnMpping.setPropertyName(bp.getName());
            if (this.logger.isDebugEnabled()) {
                logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName() + "." + columnMpping.getPropertyName(), columnMpping.getRepositoryFieldName()));
            }
            this.setColumnMapping(columnMpping, bp);
            mapping.add(columnMpping);
        }
    }

    private void mappingFk(PropertyMapping mapping, BeanProperty<?> beanProperty, String columnName, boolean hasPk, StringBuilder logInfo) {
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor((Class)beanProperty.getType());
        Collection bps = bd.findBeanPropertys((BeanPropertyMatcher)new BeanPropertyAnnotationMatcher(new Class[]{Id.class}));
        if (Lang.isEmpty((Collection)bps)) {
            throw new JdbcMappingException("#no.id.property", new Object[]{beanProperty.getType().getName()});
        }
        for (BeanProperty bp : bps) {
            PropertyMapping columnMpping = new PropertyMapping();
            columnMpping.setRepositoryFieldName(columnName);
            columnMpping.setPropertyType(bp.getType());
            columnMpping.setPropertyName(bp.getName());
            columnMpping.setPrimaryKey(hasPk);
            if (this.logger.isDebugEnabled()) {
                logInfo.append(String.format("%s###\t%s -> %s", SystemPropertyUtils.getLineSeparator(), mapping.getPropertyName() + "." + columnMpping.getPropertyName(), columnMpping.getRepositoryFieldName()));
            }
            this.setColumnMapping(columnMpping, bp);
            mapping.add(columnMpping);
        }
    }

    private <T> void checkMapping(BeanDescriptor<T> bd, Map<String, PropertyMapping> tableMapping, Table table) {
        Map<String, PropertyMapping> fieldPropertyMap = this.getFieldProperyMap(tableMapping);
        fieldPropertyMap.forEach((fieldName, property) -> {
            if (!table.hasColumn((String)fieldName)) {
                throw new JdbcMappingException("#field.not.exists", new Object[]{bd.getType().getName(), property.getPropertyName(), fieldName});
            }
        });
    }

    private Map<String, PropertyMapping> getFieldProperyMap(Map<String, PropertyMapping> tableMapping) {
        HashMap<String, PropertyMapping> nameSet = new HashMap<String, PropertyMapping>();
        tableMapping.forEach((k, v) -> {
            if (Lang.isNotEmpty((String)k)) {
                nameSet.put((String)k, (PropertyMapping)v);
            } else if (Lang.isNotEmpty((Collection)v.getPropertyMappings())) {
                v.getPropertyMappings().forEach(pm -> nameSet.put(pm.getRepositoryFieldName(), (PropertyMapping)pm));
            }
        });
        return nameSet;
    }

    private String getMappingTableName(Class<?> type) {
        String tableName = null;
        for (ClassNameConversion classNameConversion : this.classNameConversions) {
            tableName = classNameConversion.getMappingName(type);
            if (!Lang.isNotEmpty((String)tableName)) continue;
            return tableName;
        }
        return tableName;
    }

    private String getMappingColumnName(BeanProperty<?> type) {
        String columnName = null;
        for (PropertyNameConversion propertyNameConversion : this.propertyNameConversions) {
            columnName = propertyNameConversion.getMappingName(type);
            if (!Lang.isNotEmpty((String)columnName)) continue;
            return columnName;
        }
        return columnName;
    }

    private Table getMappingTable(String tableName) {
        Table tm = this.metadata.getTable(tableName);
        if (this.checkMapping && tm == null) {
            throw new JdbcMappingException("#talbe.not.exists", new Object[]{tableName});
        }
        return tm;
    }

    public boolean isCheckMapping() {
        return this.checkMapping;
    }

    public void setCheckMapping(boolean checkMapping) {
        this.checkMapping = checkMapping;
    }
}

