/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.dml;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.dml.SqlConditionBuilder;
import cn.featherfly.common.db.builder.dml.SqlConditionExpression;
import cn.featherfly.common.db.builder.dml.SqlLogicExpression;
import cn.featherfly.common.db.builder.dml.SqlSortBuilder;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.repository.builder.BuilderException;
import cn.featherfly.common.repository.builder.BuilderExceptionCode;
import cn.featherfly.common.repository.builder.dml.ConditionBuilder;
import cn.featherfly.common.repository.builder.dml.ConditionGroup;
import cn.featherfly.common.repository.builder.dml.Expression;
import cn.featherfly.common.repository.builder.dml.ExpressionBuilder;
import cn.featherfly.common.repository.builder.dml.LogicBuilder;
import cn.featherfly.common.repository.builder.dml.ParamedExpression;
import cn.featherfly.common.repository.builder.dml.SortBuilder;
import cn.featherfly.common.repository.operate.LogicOperator;
import cn.featherfly.common.repository.operate.QueryOperator;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

public class SqlConditionGroup
implements ConditionGroup,
SqlConditionBuilder {
    private List<Expression> conditions = new ArrayList<Expression>();
    private Dialect dialect;
    private SqlConditionGroup parent;
    private SqlSortBuilder sort;
    private Expression previousCondition;
    private String queryAlias;
    private Predicate<Object> ignorePolicy;

    public SqlConditionGroup(Dialect dialect, Predicate<Object> ignorePolicy, SqlSortBuilder sort) {
        this(dialect, null, ignorePolicy, sort);
    }

    public SqlConditionGroup(Dialect dialect, String queryAlias, Predicate<Object> ignorePolicy, SqlSortBuilder sort) {
        this(dialect, queryAlias, ignorePolicy, sort, null);
    }

    SqlConditionGroup(Dialect dialect, String queryAlias, Predicate<Object> ignorePolicy, SqlSortBuilder sort, SqlConditionGroup parent) {
        this.dialect = dialect;
        this.sort = sort;
        this.parent = parent;
        this.queryAlias = queryAlias;
        this.setIgnorePolicy(ignorePolicy);
    }

    public ExpressionBuilder and() {
        this.addCondition((Expression)new SqlLogicExpression(LogicOperator.AND));
        return this;
    }

    public ExpressionBuilder or() {
        this.addCondition((Expression)new SqlLogicExpression(LogicOperator.OR));
        return this;
    }

    public LogicBuilder lt(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.LT, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder le(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.LE, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder eq(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.EQ, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder ne(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.NE, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder ge(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.GE, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder gt(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.GT, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder sw(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.SW, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder co(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.CO, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder ew(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.EW, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder in(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.IN, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder nin(String name, Object value) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, value, QueryOperator.NIN, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder isn(String name) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, null, QueryOperator.ISN, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public LogicBuilder inn(String name) {
        this.addCondition((Expression)new SqlConditionExpression(this.dialect, name, null, QueryOperator.INN, this.queryAlias, this.ignorePolicy));
        return this;
    }

    public ExpressionBuilder group() {
        SqlConditionGroup group = new SqlConditionGroup(this.dialect, this.queryAlias, this.ignorePolicy, this.sort, this);
        this.addCondition((Expression)group);
        return group;
    }

    public LogicBuilder endGroup() {
        return this.parent;
    }

    public SortBuilder sort() {
        return this.sort;
    }

    public String build() {
        Expression last;
        StringBuilder result = new StringBuilder();
        if (this.conditions.size() > 0 && (last = this.conditions.get(this.conditions.size() - 1)) instanceof SqlLogicExpression) {
            throw new BuilderException(BuilderExceptionCode.createNoConditionBehindCode((String)((SqlLogicExpression)last).getLogicOperator().name()));
        }
        ArrayList<String> availableConditions = new ArrayList<String>();
        ArrayList<Expression> availableExpressions = new ArrayList<Expression>();
        for (Expression expression : this.conditions) {
            Expression pre;
            String condition = expression.build();
            if (Strings.isNotBlank((String)condition)) {
                availableConditions.add(condition);
                availableExpressions.add(expression);
                continue;
            }
            if (availableExpressions.size() <= 0 || !((pre = (Expression)availableExpressions.get(availableExpressions.size() - 1)) instanceof SqlLogicExpression)) continue;
            availableExpressions.remove(availableExpressions.size() - 1);
            availableConditions.remove(availableConditions.size() - 1);
        }
        if (availableExpressions.size() > 0 && availableExpressions.get(0) instanceof SqlLogicExpression) {
            availableExpressions.remove(0);
            availableConditions.remove(0);
        }
        for (String condition : availableConditions) {
            BuilderUtils.link(result, condition);
        }
        if (result.length() > 0 && this.parent != null) {
            return " ( " + result.toString() + " ) ";
        }
        return result.toString();
    }

    public Object getParamValue() {
        return this.getParamValues();
    }

    public List<Object> getParamValues() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression condition : this.conditions) {
            Object param;
            if (!(condition instanceof ParamedExpression) || this.ignorePolicy.test(param = ((ParamedExpression)condition).getParamValue())) continue;
            if (param instanceof Collection) {
                params.addAll((Collection)param);
                continue;
            }
            if (param.getClass().isArray()) {
                int length = Array.getLength(param);
                for (int i = 0; i < length; ++i) {
                    params.add(Array.get(param, i));
                }
                continue;
            }
            params.add(param);
        }
        return params;
    }

    private void addCondition(Expression condition) {
        if (this.previousCondition != null && this.previousCondition.getClass().isInstance(condition)) {
            throw new BuilderException(BuilderExceptionCode.createNextToSameConditionCode((String)condition.getClass().getName()));
        }
        this.previousCondition = condition;
        this.conditions.add(condition);
    }

    public Predicate<Object> getIgnorePolicy() {
        return this.ignorePolicy;
    }

    public void setIgnorePolicy(Predicate<Object> ignorePolicy) {
        AssertIllegalArgument.isNotNull(ignorePolicy, (String)"ignorePolicy");
        this.ignorePolicy = ignorePolicy;
    }

    public List<Expression> getConditions() {
        return this.conditions;
    }

    public String getQueryAlias() {
        return this.queryAlias;
    }

    public void setQueryAlias(String queryAlias) {
        this.queryAlias = queryAlias;
        this.sort.setTableAlias(queryAlias);
    }

    @Override
    public ConditionBuilder where() {
        return this;
    }
}

