/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.SimpleExecution;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SqlUtils {
    public static final char PARAM_NAME_START_SYMBOL = ':';
    private static final Pattern SELECT_PATTERN = Pattern.compile("((select )(distinct [\\w-_.]+)?,?.+)(from .+)", 34);

    private SqlUtils() {
    }

    public static String convertSelectToCount(String sql) {
        Matcher m = SELECT_PATTERN.matcher(sql = sql.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("[" + sql + "] \u4e0d\u662f\u67e5\u8be2SQL , \u67e5\u8be2SQL\u5e94\u8be5\u662f\u8fd9\u6837?[select xx from xxx ...]");
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(");
        String fromSql = sql.substring(m.group(1).length());
        String distinctColumn = null;
        int groupThree = 3;
        if (m.group(groupThree) != null) {
            distinctColumn = sql.substring(m.group(2).length(), m.group(2).length() + m.group(groupThree).length());
        }
        if (Lang.isEmpty(distinctColumn)) {
            countSql.append("*");
        } else {
            countSql.append(distinctColumn);
        }
        return countSql.append(") ").append(fromSql).toString();
    }

    public static String transferStringForSql(String str) {
        if (Lang.isEmpty((String)str)) {
            return str;
        }
        return str.replaceAll("[\\\\'\"]", "\\\\$0");
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params) {
        return SqlUtils.convertNamedParamSql(namedParamSql, params, ':');
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params, char startSymbol) {
        return SqlUtils.convertNamedParamSql(namedParamSql, params, startSymbol, null);
    }

    public static Execution convertNamedParamSql(String namedParamSql, Map<String, Object> params, char startSymbol, Character endSymbol) {
        AssertIllegalArgument.isNotEmpty((String)namedParamSql, (String)"namedParamSql");
        AssertIllegalArgument.isNotEmpty((Object)Character.valueOf(startSymbol), (String)"startSymbol");
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        boolean emptySymbol = Lang.isEmpty((Object)endSymbol);
        char end = emptySymbol ? (char)' ' : (char)endSymbol.charValue();
        boolean isEnd = false;
        boolean isEndSign = false;
        boolean isSplitSymbol = false;
        for (int index = 0; index < namedParamSql.length(); ++index) {
            char c = namedParamSql.charAt(index);
            isSplitSymbol = SqlUtils.isSqlWordSplitChar(c);
            if (startSymbol == c) {
                nameStartIndex = index;
            }
            if (nameStartIndex > 0) {
                String name;
                Object param;
                isEnd = index == namedParamSql.length() - 1;
                boolean bl = isEndSign = c == end || isSplitSymbol;
                if (!isEndSign && !isEnd) continue;
                nameEndIndex = index;
                if (!isEndSign && isEnd && emptySymbol) {
                    ++nameEndIndex;
                }
                if ((param = SqlUtils.getNamedParam(params, name = namedParamSql.substring(nameStartIndex + 1, nameEndIndex))) instanceof Collection) {
                    paramList.addAll((Collection)param);
                    SqlUtils.setParams(sql, ((Collection)param).size(), namedParamSql, nameStartIndex);
                } else if (param.getClass().isArray()) {
                    int length = Array.getLength(param);
                    for (int i = 0; i < length; ++i) {
                        paramList.add(Array.get(param, i));
                    }
                    SqlUtils.setParams(sql, length, namedParamSql, nameStartIndex);
                } else {
                    paramList.add(param);
                    sql.append('?');
                }
                if (!emptySymbol) {
                    ++nameEndIndex;
                }
                if (isSplitSymbol) {
                    sql.append(c);
                }
                nameStartIndex = -1;
                nameEndIndex = -1;
                continue;
            }
            sql.append(c);
        }
        return new SimpleExecution(sql.toString(), paramList.toArray());
    }

    private static void setParams(StringBuilder sql, int length, String namedParamSql, int nameStartIndex) {
        if (SqlUtils.isInCondition(namedParamSql, nameStartIndex)) {
            SqlUtils.sqlInParams(sql, length);
        } else {
            sql.append('?');
        }
    }

    private static boolean isInCondition(String namedParamSql, int nameStartIndex) {
        int endIndex = -1;
        for (int i = nameStartIndex; i >= 0; --i) {
            char c = namedParamSql.charAt(i);
            if (!SqlUtils.isSqlWordSplitChar(c)) continue;
            if (endIndex < 0) {
                endIndex = i;
                continue;
            }
            return "in".equalsIgnoreCase(namedParamSql.substring(i + 1, endIndex).trim());
        }
        return false;
    }

    private static void sqlInParams(StringBuilder sql, int size) {
        sql.append('(');
        for (int i = 0; i < size; ++i) {
            sql.append('?').append(',');
        }
        if (sql.length() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(')');
    }

    private static boolean isSqlWordSplitChar(char c) {
        return c == ' ' || c == '\n' || c == ',' || c == ')' || c == '\t';
    }

    private static Object getNamedParam(Map<String, Object> params, String name) {
        Object param = params.get(name);
        if (param == null) {
            throw new JdbcException("no param found for name -> " + name);
        }
        return param;
    }
}

