/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.db.JdbcException;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class SqlFile {
    public static final String INCLUDE_SYMBOL = "--@include";
    public static final String END_SQL_SIGN = ";";
    private String file;
    private Charset charset = StandardCharsets.UTF_8;
    private Map<String, String> includeFiles = new HashMap<String, String>();
    private List<String> sqlList = new ArrayList<String>(0);
    private IncludeExistPolicy includeExistPolicy = IncludeExistPolicy.IGNORE;

    public Charset getCharset() {
        return this.charset;
    }

    public IncludeExistPolicy getIncludeExistPolicy() {
        return this.includeExistPolicy;
    }

    public SqlFile(String file) {
        this.file = file;
    }

    public SqlFile(String file, Charset charset) {
        this.file = file;
        this.charset = charset;
    }

    public Map<String, String> getIncludeFiles() {
        return this.includeFiles;
    }

    public String getFile() {
        return this.file;
    }

    public List<String> getSqlList() {
        return this.sqlList;
    }

    public String toString() {
        return "SqlFile [file=" + this.file + ", charset=" + this.charset + ", includeFiles=" + this.includeFiles + ", sqlList=" + this.sqlList + ", includeExistPolicy=" + (Object)((Object)this.includeExistPolicy) + "]";
    }

    public boolean addInclude(String source, String include) {
        if (this.includeFiles.containsKey(include)) {
            switch (this.includeExistPolicy) {
                case EXCEPTION: {
                    throw new JdbcException(Strings.format((String)"file {0} already include", (Object)include));
                }
                case IGNORE: {
                    return false;
                }
            }
        }
        this.includeFiles.put(include, source);
        return true;
    }

    public void write(OutputStream os) throws IOException {
        this.write(os, this.charset);
    }

    public void write(OutputStream os, Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, charset);
        for (String sql : this.sqlList) {
            if (!Lang.isNotEmpty((String)sql)) continue;
            writer.write(sql);
            writer.write(END_SQL_SIGN);
            writer.write(10);
        }
        writer.flush();
        writer.close();
    }

    public void write(File file) throws IOException {
        this.write(file, this.charset);
    }

    public void write(File file, Charset charset) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        this.write(os, charset);
        os.flush();
        os.close();
    }

    public static SqlFile read(File file) throws IOException {
        return SqlFile.read(file, StandardCharsets.UTF_8);
    }

    public static SqlFile read(File file, Charset charset) throws IOException {
        return SqlFile.read(file, charset, IncludeExistPolicy.IGNORE);
    }

    public static SqlFile read(File file, Charset charset, IncludeExistPolicy includeExistPolicy) throws IOException {
        SqlFile sqlFile = new SqlFile(file.getAbsolutePath(), charset);
        if (includeExistPolicy != null) {
            sqlFile.includeExistPolicy = includeExistPolicy;
        }
        SqlFile.read(file, charset, sqlFile);
        return sqlFile;
    }

    public static SqlFile read(File file, Map<String, Object> params) throws IOException {
        return SqlFile.read(file, StandardCharsets.UTF_8, params);
    }

    public static SqlFile read(File file, Charset charset, Map<String, Object> params) throws IOException {
        return SqlFile.read(file, charset, IncludeExistPolicy.IGNORE, params);
    }

    public static SqlFile read(File file, Charset charset, IncludeExistPolicy includeExistPolicy, Map<String, Object> params) throws IOException {
        SqlFile sqlFile = new SqlFile(file.getAbsolutePath(), charset);
        if (includeExistPolicy != null) {
            sqlFile.includeExistPolicy = includeExistPolicy;
        }
        SqlFile.read(file, charset, sqlFile, params);
        return sqlFile;
    }

    private static void read(File file, Charset charset, SqlFile sqlFile) throws IOException {
        SqlFile.read(file.toURI().toURL(), charset, sqlFile);
    }

    private static void read(File file, Charset charset, SqlFile sqlFile, Map<String, Object> params) throws IOException {
        SqlFile.read(file.toURI().toURL(), charset, sqlFile, params);
    }

    private static void read(URL resource, Charset charset, SqlFile sqlFile) throws IOException {
        SqlFile.read(resource, charset, sqlFile, null);
    }

    private static void read(URL resource, Charset charset, SqlFile sqlFile, Map<String, Object> params) throws IOException {
        String[] sqls;
        String content = IOUtils.toString((URL)resource, (Charset)charset);
        if (Lang.isNotEmpty(params)) {
            content = Strings.format((String)content, params);
        }
        for (String sql : sqls = content.split(END_SQL_SIGN)) {
            if ((sql = sql.trim()).startsWith(INCLUDE_SYMBOL)) {
                File file;
                String path;
                File includeFile;
                String includePath = StringUtils.substringAfter((String)sql, (String)INCLUDE_SYMBOL).trim();
                URL includeResource = null;
                if (!includePath.startsWith("/") && (includeFile = new File(path = (file = new File(resource.getPath())).getParent() + "/" + includePath)).exists()) {
                    includeResource = includeFile.toURI().toURL();
                }
                if (includeResource == null) {
                    includeResource = ClassLoaderUtils.getResource((String)includePath);
                }
                if (includeResource == null) {
                    throw new IllegalArgumentException(Strings.format((String)"can not found {0} in filepath and classpath ", (Object)includePath));
                }
                sqlFile.getSqlList().add("\n-- include  " + includePath + " start");
                if (sqlFile.addInclude(resource.getFile(), includeResource.getFile())) {
                    SqlFile.read(includeResource, charset, sqlFile, params);
                }
                sqlFile.getSqlList().add("\n-- include  " + includePath + " end");
                continue;
            }
            sqlFile.getSqlList().add(sql);
        }
    }

    public static enum IncludeExistPolicy {
        IGNORE,
        EXCEPTION,
        INCLUDE;

    }
}

