/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.SqlFile;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.wrapper.ConnectionWrapper;
import cn.featherfly.common.db.wrapper.StatementWrapper;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Execution;
import cn.featherfly.common.repository.mapping.RowMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String END_SQL_SIGN = ";";
    private DataSource dataSource;
    private char namedParamStartSymbol = (char)58;
    private Character namedParamEndSymbol;

    public SqlExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void execute(SqlFile sqlFile) throws IOException {
        this.execute((String[])Lang.toArray(sqlFile.getSqlList(), String.class));
    }

    public void execute(File sqlFile) throws IOException {
        this.execute(sqlFile, StandardCharsets.UTF_8);
    }

    public void execute(File sqlFile, String encoding) throws IOException {
        AssertIllegalArgument.isExists((File)sqlFile, (String)"sqlFile");
        String content = FileUtils.readFileToString((File)sqlFile, (String)encoding);
        String[] sqls = content.split(END_SQL_SIGN);
        this.execute(sqls);
    }

    public void execute(File sqlFile, Charset charset) throws IOException {
        AssertIllegalArgument.isExists((File)sqlFile, (String)"sqlFile");
        String content = FileUtils.readFileToString((File)sqlFile, (Charset)charset);
        String[] sqls = content.split(END_SQL_SIGN);
        this.execute(sqls);
    }

    public void execute(InputStream sqlResource, Charset charset) throws IOException {
        AssertIllegalArgument.isNotNull((Object)sqlResource, (String)"sqlFile");
        String content = IOUtils.toString((InputStream)sqlResource, (Charset)charset);
        String[] sqls = content.split(END_SQL_SIGN);
        this.execute(sqls);
    }

    public void execute(String sqlContent) {
        String[] sqls = sqlContent.split(END_SQL_SIGN);
        this.execute(sqls);
    }

    public void execute(String[] sqls) {
        try (ConnectionWrapper connection = JdbcUtils.getConnectionWrapper(this.dataSource);
             StatementWrapper statement = connection.createStatement();){
            for (String sql : sqls) {
                if (!Lang.isNotEmpty((String)(sql = sql.trim()))) continue;
                this.logger.debug("add sql -> " + sql);
                statement.addBatch(sql);
            }
            statement.executeBatch();
        }
    }

    /*
     * Exception decompiling
     */
    public int execute(String sql, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int execute(String sql, Map<String, Object> params) {
        return this.execute(SqlUtils.convertNamedParamSql(sql, params, this.namedParamStartSymbol, this.namedParamEndSymbol));
    }

    public int execute(Execution execution) {
        if (execution != null) {
            return this.execute(execution.getExecution(), execution.getParams());
        }
        return 0;
    }

    public int execute(Execution ... executions) {
        int result = 0;
        if (executions != null) {
            for (Execution execution : executions) {
                result += this.execute(execution);
            }
        }
        return result;
    }

    public <E> List<E> query(Execution query, RowMapper<E> mapper) {
        if (query != null) {
            return this.query(query.getExecution(), mapper, query.getParams());
        }
        return new ArrayList();
    }

    public <E> List<E> query(String sql, RowMapper<E> mapper, Map<String, Object> params) {
        return this.query(SqlUtils.convertNamedParamSql(sql, params, this.namedParamStartSymbol, this.namedParamEndSymbol), mapper);
    }

    /*
     * Exception decompiling
     */
    public <E> List<E> query(String sql, RowMapper<E> mapper, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, Object>> query(Execution query) {
        if (query != null) {
            return this.query(query.getExecution(), query.getParams());
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> query(String sql, Map<String, Object> params) {
        return this.query(SqlUtils.convertNamedParamSql(sql, params, this.namedParamStartSymbol, this.namedParamEndSymbol));
    }

    /*
     * Exception decompiling
     */
    public List<Map<String, Object>> query(String sql, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Object[]> queryListArray(Execution query) {
        if (query != null) {
            return this.queryListArray(query.getExecution(), query.getParams());
        }
        return new ArrayList<Object[]>();
    }

    public List<Object[]> queryListArray(String sql, Map<String, Object> params) {
        return this.queryListArray(SqlUtils.convertNamedParamSql(sql, params, this.namedParamStartSymbol, this.namedParamEndSymbol));
    }

    /*
     * Exception decompiling
     */
    public List<Object[]> queryListArray(String sql, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public char getNamedParamStartSymbol() {
        return this.namedParamStartSymbol;
    }

    public void setNamedParamStartSymbol(char namedParamStartSymbol) {
        this.namedParamStartSymbol = namedParamStartSymbol;
    }

    public Character getNamedParamEndSymbol() {
        return this.namedParamEndSymbol;
    }

    public void setNamedParamEndSymbol(Character namedParamEndSymbol) {
        this.namedParamEndSymbol = namedParamEndSymbol;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

