/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.mapping.mappers;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.mapping.AbstractGenericJavaSqlTypeMapper;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.GenericType;
import cn.featherfly.common.lang.NumberUtils;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLType;

public class NumberArrayJavaSqlTypeMapper<N extends Number>
extends AbstractGenericJavaSqlTypeMapper<N[]> {
    private Class<N> numberType;

    public NumberArrayJavaSqlTypeMapper(Class<N> numberType) {
        this.numberType = numberType;
    }

    @Override
    public boolean support(SQLType sqlType) {
        return JDBCType.VARCHAR == sqlType || JDBCType.NVARCHAR == sqlType || JDBCType.CHAR == sqlType || JDBCType.NCHAR == sqlType;
    }

    @Override
    public boolean support(GenericType<N[]> type) {
        return this.getGenericType().getType().equals(type.getType());
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex, N[] values) {
        if (values != null) {
            StringBuilder result = new StringBuilder();
            for (N value : values) {
                result.append(value).append(",");
            }
            if (result.length() > 0) {
                result.deleteCharAt(result.length() - 1);
            }
            JdbcUtils.setParameter(prep, parameterIndex, (Object)result.toString());
        } else {
            JdbcUtils.setParameter(prep, parameterIndex, null);
        }
    }

    @Override
    public N[] get(ResultSet rs, int columnIndex) {
        String value = (String)JdbcUtils.getResultSetValue(rs, columnIndex, String.class);
        if (value != null) {
            String[] values = value.split(",");
            Number[] numbers = (Number[])ArrayUtils.create(this.numberType, (int)values.length);
            for (int i = 0; i < values.length; ++i) {
                numbers[i] = NumberUtils.parse((String)values[i], this.numberType);
            }
            return numbers;
        }
        return null;
    }
}

