/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.Column;
import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.util.Date;

public class MySQLDialect
extends AbstractDialect {
    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false, ':');
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getParamNamedPaginationSql(sql, start, limit, ':');
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit, char startSymbol) {
        return this.getPaginationSql(sql, start, true, startSymbol);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed, char startSymbol) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(Strings.format((String)" LIMIT {0}{1},{0}{2}", (Object[])Lang.array((Object[])new Object[]{Character.valueOf(':'), "dialect_paging_start", "dialect_paging_limit"})));
            } else {
                pagingSelect.append(Strings.format((String)" LIMIT {0}{1}", (Object[])Lang.array((Object[])new Object[]{Character.valueOf(':'), "dialect_paging_limit"})));
            }
        } else if (start > 0) {
            pagingSelect.append(" LIMIT ?,?");
        } else {
            pagingSelect.append(" LIMIT ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("'").append(Dates.formatTime((Date)((Date)value))).append("'");
                        break;
                    }
                    sqlPart.append("'").append(value).append("'");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (Lang.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getWrapSign() {
        return "`";
    }

    public String getFkCheck(boolean check) {
        return "SET FOREIGN_KEY_CHECKS=" + (check ? 1 : 0);
    }

    @Override
    protected String getAutoIncrement(Column column) {
        if (column.isAutoincrement()) {
            return "AUTO_INCREMENT";
        }
        return "";
    }

    @Override
    public String getColumnTypeName(SQLType sqlType) {
        JDBCType type = JDBCType.valueOf(sqlType.getVendorTypeNumber());
        switch (type) {
            case INTEGER: {
                return "INT";
            }
        }
        return super.getColumnTypeName(sqlType);
    }

    @Override
    public String getInitSqlHeader() {
        return this.getFkCheck(false);
    }

    @Override
    public String getInitSqlFooter() {
        return this.getFkCheck(true);
    }

    @Override
    public String getDefaultSchema(String catalog) {
        return catalog;
    }

    @Override
    public String buildDropIndexDDL(String schema, String tableName, String indexName, boolean ifExists) {
        String tn;
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        AssertIllegalArgument.isNotEmpty((String)indexName, (String)"indexName");
        String in = Lang.isEmpty((String)schema) ? this.wrapName(indexName) : this.wrapName(schema) + "." + this.wrapName(indexName);
        String string = tn = Lang.isEmpty((String)schema) ? this.wrapName(tableName) : this.wrapName(schema) + "." + this.wrapName(tableName);
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), in, this.getKeyword(Keywords.ON), tn) + ";";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), in, this.getKeyword(Keywords.ON), tn) + ";";
    }
}

