/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data.query;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.Query;
import cn.featherfly.common.repository.builder.dml.ConditionBuilder;

public class TableQuery
implements Query {
    private String tableName;
    private String sql;
    private Object[] params = new Object[0];

    public TableQuery(Dialect dialect, String tableName) {
        this(dialect, tableName, null);
    }

    public TableQuery(Dialect dialect, String tableName, ConditionBuilder conditionBuilder) {
        String condition;
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(dialect.buildTableSql(tableName));
        if (conditionBuilder != null && Lang.isNotEmpty((String)(condition = conditionBuilder.build()))) {
            BuilderUtils.link(sql, dialect.getKeyword(Keywords.WHERE), condition);
        }
        this.sql = sql.toString();
        this.tableName = tableName;
    }

    public String getName() {
        return this.tableName;
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String getExecution() {
        return this.sql;
    }
}

