/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.migration;

import cn.featherfly.common.db.migration.Migrator;
import cn.featherfly.common.db.migration.Version;
import cn.featherfly.common.io.Properties;
import cn.featherfly.common.io.PropertiesImpl;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.repository.mapping.ClassMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class VersionManager {
    private static final String VERSION_FILE_NAME = ".versions.properties";
    public static final Version DEFAULT_INIT_VERSION = new Version(1, 0, 0);
    public static final String INIT_VERSION_KEY = "init_version";
    public static final String CURRENT_VERSION_KEY = "current_version";
    private File dir;
    private File file;
    private Properties properties;
    private String name;
    private Migrator migrator;
    private Version current;
    private Version init;
    private boolean dropNotExist = true;
    private Migrator.ModifyType modifyType = Migrator.ModifyType.MODIFY;

    public VersionManager(File dir, String name, Migrator migrator) {
        this(dir, name, DEFAULT_INIT_VERSION, migrator);
    }

    public VersionManager(File dir, String name, Version initVersion, Migrator migrator) {
        this.name = name;
        this.migrator = migrator;
        this.dir = dir;
        if (dir == null) {
            throw new IllegalArgumentException(dir + " can not be null");
        }
        if (Lang.isNotExists((File)dir)) {
            cn.featherfly.common.io.FileUtils.makeDirectory((File)dir);
        }
        this.file = new File(dir.getAbsolutePath() + "/" + VERSION_FILE_NAME);
        this.init = initVersion;
        this.properties = new PropertiesImpl(StandardCharsets.UTF_8);
        if (Lang.isExists((File)this.file)) {
            try {
                this.properties.load((InputStream)new FileInputStream(this.file));
            }
            catch (IOException e) {
                Lang.wrapThrow((IOException)e);
            }
        }
        this.properties.setProperty(INIT_VERSION_KEY, this.init.getVersion());
        String currentVersoin = this.properties.getProperty(CURRENT_VERSION_KEY);
        if (Lang.isNotEmpty((String)currentVersoin)) {
            this.current = Version.create(currentVersoin);
        }
        this.store();
    }

    private void store() {
        try (FileOutputStream os = new FileOutputStream(this.file);){
            this.properties.store((OutputStream)os);
        }
        catch (IOException e) {
            Lang.wrapThrow((IOException)e);
        }
    }

    public String getCurrentVersion() {
        if (this.current == null) {
            return this.init.getVersion();
        }
        return this.current.getVersion();
    }

    public File next(Set<ClassMapping<?>> classMappings) {
        String version = null;
        File f = null;
        if (this.current == null) {
            version = this.init.getVersion();
            f = this.createInitSqlFile(version, classMappings);
        } else {
            version = this.current.getNextMinorVersion();
            f = this.createUpdateSqlFile(version, classMappings);
        }
        this.properties.setProperty(CURRENT_VERSION_KEY, version);
        this.properties.setProperty(version, Dates.formatTime((Date)new Date()));
        this.store();
        return f;
    }

    public File next(Set<ClassMapping<?>> classMappings, Version next) {
        String version = null;
        File f = null;
        if (this.current == null) {
            version = this.init.getVersion();
            f = this.createInitSqlFile(version, classMappings);
        } else {
            version = next.getVersion();
            f = this.createUpdateSqlFile(version, classMappings);
        }
        this.properties.setProperty(CURRENT_VERSION_KEY, version);
        this.properties.setProperty(version, Dates.formatTime((Date)new Date()));
        this.store();
        return f;
    }

    private String name(String version, String type) {
        String extName = cn.featherfly.common.io.FileUtils.getFileExtName((String)this.name);
        if (Lang.isEmpty((String)extName)) {
            extName = "sql";
        }
        return this.name + "-" + version + "-" + type + "." + extName;
    }

    public File createInitSqlFile(String version, Set<ClassMapping<?>> classMappings) {
        File file = new File(this.dir.getPath() + "/" + this.name(version, "init"));
        try {
            FileUtils.write((File)file, (CharSequence)this.migrator.initSql(classMappings), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Lang.wrapThrow((IOException)e);
        }
        return file;
    }

    public File createUpdateSqlFile(String version, Set<ClassMapping<?>> classMappings) {
        File file = new File(this.dir.getPath() + "/" + this.name(version, "update"));
        try {
            FileUtils.write((File)file, (CharSequence)this.migrator.updateSql(classMappings, this.modifyType, this.dropNotExist), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Lang.wrapThrow((IOException)e);
        }
        return file;
    }

    public boolean isDropNotExist() {
        return this.dropNotExist;
    }

    public void setDropNotExist(boolean dropNotExist) {
        this.dropNotExist = dropNotExist;
    }

    public Migrator.ModifyType getModifyType() {
        return this.modifyType;
    }

    public void setModifyType(Migrator.ModifyType modifyType) {
        this.modifyType = modifyType;
    }
}

